/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.npcaddon.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.limeglass.npcaddon.NpcAddon;
import me.limeglass.npcaddon.util.ReflectionUtil;
import me.limeglass.npcaddon.util.npcs.Npc;
import me.limeglass.npcaddon.util.npcs.NpcDamageEvent;
import me.limeglass.npcaddon.util.npcs.NpcInteractEvent;
import me.limeglass.npcaddon.util.npcs.NpcManager;
import net.minecraft.server.v1_11_R1.PacketPlayInUseEntity;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PacketListener
implements Listener {
    private ArrayList<UUID> firedTwice = new ArrayList();
    private HashMap<Player, String> handlers = new HashMap();

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.create(event.getPlayer());
        NpcManager.updateNpcs(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.remove(event.getPlayer());
    }

    private void remove(Player player) {
        try {
            Channel channel = ReflectionUtil.getChannel(player);
            channel.eventLoop().submit(() -> {
                channel.pipeline().remove(this.handlers.get(player));
                return null;
            });
            this.handlers.remove(player);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void create(final Player player) {
        ChannelDuplexHandler channelDuplexHandler = new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext context, Object packet) throws Exception {
                if (packet.getClass().getSimpleName().equalsIgnoreCase("PacketPlayInUseEntity")) {
                    PacketPlayInUseEntity.EnumEntityUseAction action = (PacketPlayInUseEntity.EnumEntityUseAction)PacketListener.this.getValue(packet, "action");
                    final UUID uuid = player.getUniqueId();
                    int i = (Integer)PacketListener.this.getValue(packet, "a");
                    Npc npc = NpcManager.npcs.get(i);
                    if (NpcManager.npcs.containsKey(i) && !PacketListener.this.firedTwice.contains(uuid)) {
                        PacketListener.this.firedTwice.add(uuid);
                        NpcInteractEvent event = new NpcInteractEvent(player, npc, action != PacketPlayInUseEntity.EnumEntityUseAction.ATTACK);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        NpcDamageEvent damageEvent = new NpcDamageEvent(player, npc);
                        if (action == PacketPlayInUseEntity.EnumEntityUseAction.ATTACK) {
                            Bukkit.getServer().getPluginManager().callEvent((Event)damageEvent);
                        }
                        Bukkit.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)NpcAddon.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                PacketListener.this.firedTwice.remove(uuid);
                            }
                        }, 20L);
                        if (event.isCancelled() || damageEvent.isCancelled()) {
                            return;
                        }
                    }
                }
                super.channelRead(context, packet);
            }

            public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) throws Exception {
                super.write(context, packet, channelPromise);
            }
        };
        try {
            Channel channel = ReflectionUtil.getChannel(player);
            ChannelPipeline pipeline = channel.pipeline();
            int ID = 0;
            String name = player.getName();
            while (pipeline.get(name) != null) {
                name = String.valueOf(player.getName()) + ID;
                ++ID;
            }
            pipeline.addBefore("packet_handler", name, (ChannelHandler)channelDuplexHandler);
            if (this.handlers.containsKey(player)) {
                this.remove(player);
            }
            this.handlers.put(player, name);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Object getValue(Object packet, String field) {
        try {
            Field f = packet.getClass().getDeclaredField(field);
            f.setAccessible(true);
            return f.get(packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }
}

