/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldCreator;

import com.pie.tlatoani.Generator.ChunkGeneratorWithID;
import com.pie.tlatoani.Util.Static.OptionalUtil;
import com.pie.tlatoani.WorldCreator.Dimension;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.ChunkGenerator;
import org.json.simple.JSONObject;

public class WorldCreatorData {
    public final Optional<String> name;
    public final Dimension dimension;
    public final WorldType type;
    public final Optional<String> seed;
    public final Optional<ChunkGenerator> generator;
    public final String generatorSettings;
    public final boolean structures;
    public final Optional<Long> seedLong;

    public WorldCreatorData(@Nullable String name, @Nullable Dimension dimension, @Nullable String seed, @Nullable WorldType type, @Nullable ChunkGenerator generator, @Nullable String generatorSettings, @Nullable Boolean structures) {
        this.name = Optional.ofNullable(name);
        this.dimension = Optional.ofNullable(dimension).orElse(Dimension.NORMAL);
        this.type = Optional.ofNullable(type).orElse(WorldType.NORMAL);
        this.seed = Optional.ofNullable(seed);
        this.generator = Optional.ofNullable(generator);
        this.generatorSettings = Optional.ofNullable(generatorSettings).orElse("");
        this.structures = Optional.ofNullable(structures).orElse(true);
        this.seedLong = this.seed.map(str -> {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                return str.hashCode();
            }
        });
    }

    public static WorldCreatorData withGeneratorID(@Nullable String name, @Nullable Dimension dimension, @Nullable String seed, @Nullable WorldType type, @Nullable String generatorID, @Nullable String generatorSettings, @Nullable Boolean structures) {
        return new WorldCreatorData(name, dimension, seed, type, Optional.ofNullable(generatorID).map(ChunkGeneratorWithID::getGenerator).orElse(null), generatorSettings, structures);
    }

    public static WorldCreatorData fromWorld(World world) {
        if (world == null) {
            throw new NullPointerException("The world parameter should not be null");
        }
        return new WorldCreatorData(world.getName(), Dimension.fromEnvironment(world.getEnvironment()), Long.toString(world.getSeed()), world.getWorldType(), world.getGenerator(), null, world.canGenerateStructures());
    }

    public void createWorld() {
        if (!this.name.isPresent()) {
            throw new UnsupportedOperationException("You must supply a name if you want to create a world using a nameless creator: " + this);
        }
        WorldCreator creator = new WorldCreator(this.name.get());
        creator.environment(this.dimension.toEnvironment());
        creator.type(this.type);
        creator.seed(this.seedLong.orElseGet(() -> new Random().nextLong()).longValue());
        this.generator.ifPresent(arg_0 -> ((WorldCreator)creator).generator(arg_0));
        creator.generatorSettings(this.generatorSettings);
        creator.generateStructures(this.structures);
        creator.createWorld();
    }

    public void createWorld(String name) {
        if (name == null) {
            throw new NullPointerException("The name parameter should not be null");
        }
        WorldCreator creator = new WorldCreator(name);
        creator.environment(this.dimension.toEnvironment());
        creator.type(this.type);
        creator.seed(this.seedLong.orElseGet(() -> new Random().nextLong()).longValue());
        this.generator.ifPresent(arg_0 -> ((WorldCreator)creator).generator(arg_0));
        creator.generatorSettings(this.generatorSettings);
        creator.generateStructures(this.structures);
        creator.createWorld();
    }

    public Optional<String> getGeneratorID() {
        return this.generator.flatMap(chunkGenerator -> OptionalUtil.cast(chunkGenerator, ChunkGeneratorWithID.class)).map(generatorWIthID -> generatorWIthID.id);
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"environment", (Object)this.dimension.toString());
        this.seed.ifPresent(str -> jsonObject.put((Object)"seed", str));
        jsonObject.put((Object)"worldtype", (Object)this.type.toString());
        this.getGeneratorID().ifPresent(generator -> jsonObject.put((Object)"generator", generator));
        jsonObject.put((Object)"generatorsettings", (Object)this.generatorSettings);
        jsonObject.put((Object)"structures", (Object)this.structures);
        return jsonObject;
    }

    public static Optional<WorldCreatorData> fromJSON(@Nullable String worldName, JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException("The jsonObject parameter should not be null");
        }
        try {
            Dimension dimension = Dimension.valueOf((String)jsonObject.get((Object)"environment"));
            String seed = (String)jsonObject.get((Object)"seed");
            WorldType type = WorldType.valueOf((String)((String)jsonObject.get((Object)"worldtype")));
            String generatorID = (String)jsonObject.get((Object)"generator");
            String generatorSettings = (String)jsonObject.get((Object)"generatorsettings");
            Boolean structures = (Boolean)jsonObject.get((Object)"structures");
            return Optional.of(WorldCreatorData.withGeneratorID(worldName, dimension, seed, type, generatorID, generatorSettings, structures));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public WorldCreatorData setName(@Nullable String name) {
        return new WorldCreatorData(name, this.dimension, this.seed.orElse(null), this.type, this.generator.orElse(null), this.generatorSettings, this.structures);
    }

    public WorldCreatorData setDimension(@Nullable Dimension dimension) {
        return new WorldCreatorData(this.name.orElse(null), dimension, this.seed.orElse(null), this.type, this.generator.orElse(null), this.generatorSettings, this.structures);
    }

    public WorldCreatorData setSeed(@Nullable String seed) {
        return new WorldCreatorData(this.name.orElse(null), this.dimension, seed, this.type, this.generator.orElse(null), this.generatorSettings, this.structures);
    }

    public WorldCreatorData setType(@Nullable WorldType type) {
        return new WorldCreatorData(this.name.orElse(null), this.dimension, this.seed.orElse(null), type, this.generator.orElse(null), this.generatorSettings, this.structures);
    }

    public WorldCreatorData setGenerator(@Nullable ChunkGenerator generator) {
        return new WorldCreatorData(this.name.orElse(null), this.dimension, this.seed.orElse(null), this.type, generator, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setGeneratorID(@Nullable String id) {
        return WorldCreatorData.withGeneratorID(this.name.orElse(null), this.dimension, this.seed.orElse(null), this.type, id, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setGeneratorSettings(@Nullable String generatorSettings) {
        return new WorldCreatorData(this.name.orElse(null), this.dimension, this.seed.orElse(null), this.type, this.generator.orElse(null), generatorSettings, this.structures);
    }

    public WorldCreatorData setStructures(@Nullable Boolean structures) {
        return new WorldCreatorData(this.name.orElse(null), this.dimension, this.seed.orElse(null), this.type, this.generator.orElse(null), this.generatorSettings, structures);
    }

    public String toString() {
        return OptionalUtil.map(this.name, () -> "", str -> str + ":") + this.toJSON();
    }
}

