/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin.Skull;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Util.Static.Reflection;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.libs.jline.internal.Nullable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class SkullUtil {
    public static final String DEFAULT_SKULL_OWNER = "MundoSK-Name";
    public static final UUID DEFAULT_UUID = UUID.fromString("10001000-1000-3000-8000-100010001000");
    public static final short DURABILITY = (short)SkullType.PLAYER.ordinal();
    public static final Reflection.FieldAccessor CRAFT_META_SKULL_PROFILE = Reflection.getField(Reflection.getCraftBukkitClass("inventory.CraftMetaSkull"), "profile", Reflection.getClass("com.mojang.authlib.GameProfile"));
    public static final Reflection.FieldAccessor CRAFT_SKULL_PROFILE = Reflection.getField(Reflection.getCraftBukkitClass("block.CraftSkull"), "profile", Reflection.getClass("com.mojang.authlib.GameProfile"));

    @Nullable
    abstract WrappedGameProfile getGameProfile();

    abstract void setGameProfile(WrappedGameProfile var1);

    public abstract SkullType getSkullType();

    public abstract void setSkullType(SkullType var1);

    public Skin getSkin() {
        WrappedGameProfile gameProfile = this.getGameProfile();
        return gameProfile == null ? Skin.EMPTY : Skin.fromGameProfile(gameProfile);
    }

    public void setSkin(Skin skin) {
        this.setSkullType(SkullType.PLAYER);
        String owner = this.getOwner();
        this.setSkinAndOwner(skin, owner == null ? DEFAULT_SKULL_OWNER : owner);
    }

    public String getOwner() {
        WrappedGameProfile gameProfile = this.getGameProfile();
        return gameProfile == null ? null : gameProfile.getName();
    }

    public void setOwner(String owner) {
        this.setSkullType(SkullType.PLAYER);
        Skin skin = this.getSkin();
        this.setGameProfile(skin == null ? new WrappedGameProfile(DEFAULT_UUID, owner) : skin.toGameProfile(owner));
    }

    public void setSkinAndOwner(Skin skin, String owner) {
        this.setGameProfile(skin.toGameProfile(owner));
    }

    public static ItemStack skullItem(SkullType skullType) {
        Held heldSkull = new Held();
        heldSkull.setSkullType(skullType);
        return heldSkull.item;
    }

    public static ItemStack playerSkullItem(Skin skin) {
        return SkullUtil.playerSkullItem(skin, DEFAULT_SKULL_OWNER);
    }

    public static ItemStack playerSkullItem(Skin skin, String owner) {
        Held heldSkull = new Held();
        heldSkull.setSkinAndOwner(skin, owner);
        return heldSkull.item;
    }

    public static Optional<Held> from(ItemStack itemStack) {
        if (itemStack.getType() == Material.SKULL_ITEM) {
            return Optional.of(new Held(itemStack));
        }
        return Optional.empty();
    }

    public static Optional<Placed> from(Block block) {
        if (block.getType() == Material.SKULL) {
            return Optional.of(new Placed(block));
        }
        return Optional.empty();
    }

    public static Held make(ItemStack itemStack) {
        if (itemStack.getType() != Material.SKULL_ITEM) {
            itemStack.setType(Material.SKULL_ITEM);
        }
        return new Held(itemStack);
    }

    public static Placed make(Block block) {
        if (block.getType() != Material.SKULL) {
            block.setType(Material.SKULL);
        }
        return new Placed(block);
    }

    public static class Placed
    extends SkullUtil {
        public final Block block;

        private Placed(Block block) {
            this.block = block;
            if (block.getType() != Material.SKULL) {
                throw new IllegalArgumentException("Illegal block type: " + block.getType() + ", should be SKULL");
            }
        }

        private Skull getState() {
            return (Skull)this.block.getState();
        }

        @Override
        WrappedGameProfile getGameProfile() {
            return WrappedGameProfile.fromHandle(CRAFT_SKULL_PROFILE.get(this.getState()));
        }

        @Override
        void setGameProfile(WrappedGameProfile gameProfile) {
            Skull skull = this.getState();
            CRAFT_SKULL_PROFILE.set(skull, gameProfile.getHandle());
            skull.update();
        }

        @Override
        public SkullType getSkullType() {
            return this.getState().getSkullType();
        }

        @Override
        public void setSkullType(SkullType skullType) {
            Skull skull = this.getState();
            if (skull.getSkullType() != skullType) {
                skull.setSkullType(skullType);
            }
            skull.update();
        }
    }

    public static class Held
    extends SkullUtil {
        public final ItemStack item;

        private Held() {
            this(new ItemStack(Material.SKULL_ITEM));
            if (this.item.getDurability() != DURABILITY) {
                this.item.setDurability(DURABILITY);
            }
        }

        private Held(ItemStack item) {
            this.item = item;
            if (item.getType() != Material.SKULL_ITEM) {
                throw new IllegalArgumentException("Illegal type: " + item.getType() + ", should be SKULL_ITEM");
            }
        }

        @Override
        WrappedGameProfile getGameProfile() {
            return WrappedGameProfile.fromHandle(CRAFT_META_SKULL_PROFILE.get(this.item.getItemMeta()));
        }

        @Override
        void setGameProfile(WrappedGameProfile gameProfile) {
            ItemMeta skullMeta = this.item.getItemMeta();
            CRAFT_META_SKULL_PROFILE.set(skullMeta, gameProfile.getHandle());
            this.item.setItemMeta(skullMeta);
        }

        @Override
        public SkullType getSkullType() {
            return SkullType.values()[this.item.getDurability()];
        }

        @Override
        public void setSkullType(SkullType skullType) {
            if (this.getSkullType() != skullType) {
                this.item.setDurability((short)skullType.ordinal());
            }
        }
    }
}

