/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Group;

import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Tablist.TablistManager;
import com.pie.tlatoani.Util.Collections.Streamable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.entity.Player;

public class TablistGroup
implements Streamable<Tablist> {
    private Tablist dummy = new Tablist();
    private final Map<Player, Tablist> tablists = new HashMap<Player, Tablist>();

    public Tablist getDummy() {
        return this.dummy;
    }

    @Override
    public Iterator<Tablist> iterator() {
        return this.tablists.values().iterator();
    }

    @Override
    public Stream<Tablist> stream() {
        return this.tablists.values().stream();
    }

    public Set<Player> getPlayers() {
        return Collections.unmodifiableSet(this.tablists.keySet());
    }

    public void add(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("The player parameter in add(Player player) must be non-null and online, player: " + player);
        }
        this.tablists.computeIfAbsent(player, __ -> {
            Tablist tablist = TablistManager.getTablistOfPlayer(player);
            this.dummy.applyChanges(tablist);
            return tablist;
        });
    }

    public boolean remove(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("The player parameter in remove(Player player) must be non-null and online, player: " + player);
        }
        return this.tablists.remove(player) != null;
    }

    public void clear() {
        this.tablists.clear();
    }

    public void reset() {
        this.clear();
        this.dummy = new Tablist();
    }
}

