/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Socket;

import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import com.pie.tlatoani.Util.Static.Logging;
import com.pie.tlatoani.Util.Static.Scheduling;
import com.pie.tlatoani.Util.SyncGetter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class UtilFunctionSocket
implements Runnable {
    private Boolean status = false;
    private int port;
    private String password;
    private ServerSocket sock;
    private String handler;
    private static Map<Integer, UtilFunctionSocket> sockets = new HashMap<Integer, UtilFunctionSocket>();

    private UtilFunctionSocket(int portarg, String passarg, String handlerarg) {
        this.port = portarg;
        this.password = passarg;
        this.handler = handlerarg;
        UtilFunctionSocket.debug("Function Socket on port " + this.port + " successfully created");
    }

    private Boolean init() {
        this.status = true;
        try {
            this.sock = new ServerSocket(this.port);
            this.sock.setReuseAddress(true);
            Scheduling.async(this);
            UtilFunctionSocket.debug("Function Socket on port " + this.port + " successfully initialized");
            return true;
        }
        catch (Exception e) {
            Logging.reportException(this, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.status.booleanValue()) {
            Socket socket = null;
            try {
                UtilFunctionSocket.debug("Waiting for connection on Function Socket on port " + this.port);
                socket = this.sock.accept();
                UtilFunctionSocket.debug("New connection accepted on Function Socket on port " + this.port);
            }
            catch (IOException e) {
                if (this.status.booleanValue()) {
                    Logging.reportException(this, e);
                }
            }
            finally {
                if (this.status.booleanValue()) {
                    Scheduling.async(this);
                    UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", running task to accept new connections");
                }
            }
            if (this.status.booleanValue()) {
                try {
                    String firstline;
                    UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", about to read message");
                    BufferedReader bread = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    LinkedList<String> list = new LinkedList<String>();
                    Boolean continu = false;
                    continu = this.password == null ? Boolean.valueOf(true) : Boolean.valueOf((firstline = bread.readLine()) != null || this.password.equals(firstline));
                    if (continu.booleanValue()) {
                        String line;
                        String funcmsg = null;
                        funcmsg = this.handler != null ? this.handler : bread.readLine();
                        while ((line = bread.readLine()) != null) {
                            list.add(line);
                            UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", line " + list.size() + " of an incoming message is " + line);
                        }
                        final Object[][] args = new Object[2][1];
                        args[0] = list.toArray();
                        Object[] argsinfo = new Object[]{new Integer(this.port), socket.getInetAddress().getHostName(), new Integer(socket.getPort())};
                        args[1] = argsinfo;
                        Object[] result = null;
                        final Function function = Functions.getFunction((String)funcmsg);
                        if (function != null) {
                            result = (Object[])new SyncGetter<Object[]>(){

                                @Override
                                protected Object[] getRaw() {
                                    return function.execute(args);
                                }
                            }.getSync();
                            UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", the function " + funcmsg + "was successfully found");
                        } else {
                            UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", the function " + funcmsg + "was not found");
                        }
                        if (result != null) {
                            UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", the function " + funcmsg + "returned a value");
                            BufferedWriter bright = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                            for (int b = 0; b < result.length; ++b) {
                                bright.write(result[b].toString());
                                bright.newLine();
                                UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", line " + (b + 1) + "of an outgoing message is " + result[b].toString());
                            }
                            bright.flush();
                            socket.close();
                            UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", a connection was successfully closed");
                        } else {
                            UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", the function " + funcmsg + "did not return a value or was not found");
                        }
                    } else {
                        UtilFunctionSocket.debug("At Function Socket on port " + this.port + ", the password was incorrect, or the socket closed early.");
                    }
                }
                catch (Exception e) {
                    Logging.reportException(UtilFunctionSocket.class, e);
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void openFunctionSocket(int portarg, String passarg, String handlerarg) {
        if (!sockets.containsKey(portarg)) {
            UtilFunctionSocket.debug("Function Socket on port " + portarg + " being created");
            UtilFunctionSocket socket = new UtilFunctionSocket(portarg, passarg, handlerarg);
            if (socket.init().booleanValue()) {
                sockets.put(portarg, socket);
            }
        }
    }

    public static void closeFunctionSocket(int portarg) {
        if (sockets.containsKey(portarg)) {
            UtilFunctionSocket.debug("Function Socket on port " + portarg + " being closed");
            sockets.get(portarg).closeFunctionSocket();
            sockets.remove(portarg);
        }
    }

    private void closeFunctionSocket() {
        this.status = false;
        try {
            this.sock.close();
            UtilFunctionSocket.debug("Function Socket on port " + this.port + " successfully closed");
        }
        catch (Exception e) {
            Logging.reportException(UtilFunctionSocket.class, e);
        }
    }

    public static Boolean getStatusOfFunctionSocket(int portarg) {
        return sockets.containsKey(portarg);
    }

    public static String getPassOfFunctionSocket(int portarg) {
        if (sockets.containsKey(portarg)) {
            return sockets.get(portarg).getPass();
        }
        return null;
    }

    private String getPass() {
        return this.password;
    }

    public static String getHandlerOfFunctionSocket(int portarg) {
        if (sockets.containsKey(portarg)) {
            return sockets.get(portarg).getHandler();
        }
        return null;
    }

    private String getHandler() {
        return this.handler;
    }

    private static void debug(String msg) {
        Logging.debug(UtilFunctionSocket.class, msg);
    }

    public static void onDisable() {
        sockets.forEach((portarg, utilFunctionSocket) -> {
            UtilFunctionSocket.debug("Function Socket on port " + portarg + " being closed (Special Case - onDisable)");
            sockets.get(portarg).closeFunctionSocket();
        });
    }
}

