/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Generator;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Generator.GeneratorFunctionality;
import com.pie.tlatoani.Generator.GeneratorManager;
import com.pie.tlatoani.Util.Skript.MundoEventScope;
import com.pie.tlatoani.Util.Skript.ScopeUtil;
import java.util.Optional;
import org.bukkit.event.Event;

public class ScopeGenerator
extends MundoEventScope {
    private GeneratorFunctionality generatorFunctionality;
    private GeneratorFunctionality.Nebula nebula;

    @Override
    public void afterInit() {
        this.generatorFunctionality.load(this.nebula);
        Logging.debug((Object)this, "registered: " + this.generatorFunctionality);
    }

    public void unregister(Trigger trigger) {
        this.generatorFunctionality.unload();
        Logging.debug((Object)this, "unregistered");
    }

    public void unregisterAll() {
        GeneratorManager.unregisterAllSkriptGenerators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        this.generatorFunctionality = GeneratorManager.getSkriptGenerator((String)((String)literals[0].getSingle())).functionality;
        this.nebula = new GeneratorFunctionality.Nebula();
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        Logging.debug((Object)this, "init()ing");
        try {
            if (this.generatorFunctionality.isLoaded()) {
                Skript.warning((String)("You may have two 'generator' instances with the id \"" + this.generatorFunctionality.id + "\" in your code. If you do, note that only one of them will be used. If you don't, you can ignore this warning."));
                this.generatorFunctionality.unload();
            }
            for (Node node : topNode) {
                SkriptLogger.setNode((Node)node);
                Logging.debug((Object)this, "Current node: " + node.getKey());
                if (!(node instanceof SectionNode)) {
                    Skript.error((String)"Code under 'generator' to be run initially should be put under the 'initiation' section!");
                    boolean bl = false;
                    return bl;
                }
                SectionNode subNode = (SectionNode)node;
                if (subNode.getKey().equals("initiation")) {
                    if (this.nebula.initiation.isPresent()) {
                        Skript.error((String)"You cannot have two 'initiation' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.initiation = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("generation")) {
                    if (this.nebula.generation.isPresent()) {
                        Skript.error((String)"You cannot have two 'generation' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.generation = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("population")) {
                    if (this.nebula.population.isPresent()) {
                        Skript.error((String)"You cannot have two 'population' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.population = Optional.of(subNode);
                    continue;
                }
                Skript.error((String)"The only sections allowed under 'generator' are 'initiation', 'generation', and 'population'!");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ScopeUtil.removeSubNodes(topNode);
        }
    }

    public String toString(Event event, boolean b) {
        return "generator \"" + this.generatorFunctionality.id + "\"";
    }
}

