/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Core.Static;

import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Mundo;
import java.util.concurrent.CountDownLatch;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Scheduling {
    private static BukkitScheduler scheduler;

    public static void load() {
        scheduler = Bukkit.getScheduler();
    }

    public static void sync(Runnable runnable) {
        scheduler.runTask((Plugin)Mundo.get(), runnable);
    }

    public static void async(Runnable runnable) {
        scheduler.runTaskAsynchronously((Plugin)Mundo.get(), runnable);
    }

    public static void syncDelay(int ticks, Runnable runnable) {
        scheduler.runTaskLater((Plugin)Mundo.get(), runnable, (long)ticks);
    }

    public static void asyncDelay(int ticks, Runnable runnable) {
        scheduler.runTaskLaterAsynchronously((Plugin)Mundo.get(), runnable, (long)ticks);
    }

    public static void syncLock(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Scheduling.sync(() -> {
            runnable.run();
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Logging.reportException(runnable, e);
        }
    }
}

