/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Core.Registration;

import com.pie.tlatoani.Core.Registration.Documentation;
import com.pie.tlatoani.Core.Registration.DocumentationElement;
import com.pie.tlatoani.Core.Registration.DocumentationFileGenerator;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Core.Static.MainCommand;
import com.pie.tlatoani.Core.Static.Utilities;
import com.pie.tlatoani.Util.Collections.ImmutableGroupedList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public class DocumentationCommand {
    public static final int ELEMENTS_PER_PAGE = 12;

    public static void accessDocumentation(CommandSender sender, String[] args) {
        if (DocumentationCommand.listDocumentation(sender, args)) {
            return;
        }
        String docElemName = String.join((CharSequence)" ", args).substring(args[0].length() + 1).toLowerCase();
        Logging.debug(Documentation.class, "Searching for a DocElem named '" + docElemName + "'");
        for (List<DocumentationElement> docElems : Documentation.getAllElements().getAllGroups()) {
            Logging.debug(Documentation.class, "Searching through " + docElems);
            Optional<DocumentationElement> docElemOptional = Utilities.binarySearchCeiling(docElems, docElemName, (name, docElem) -> Documentation.WORD_BY_WORD_COMPARATOR.compare((String)name, docElem.name.toLowerCase()));
            Logging.debug(DocumentationCommand.class, "Found docElem " + docElemOptional);
            if (!docElemOptional.filter(docElem -> Utilities.wordsStartWith(docElem.name.toLowerCase(), docElemName)).isPresent()) continue;
            docElemOptional.get().display(sender);
            return;
        }
        sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "Invalid command. Do " + MainCommand.ALT_CHAT_COLOR + "/mundosk doc help" + MainCommand.PRIMARY_CHAT_COLOR + " for help");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean listDocumentation(CommandSender sender, String[] args) {
        int page;
        if (args.length == 1 || args[1].equalsIgnoreCase("help")) {
            sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "MundoSK Documentation Command Help");
            sender.sendMessage(MainCommand.formatCommandDescription("doc[s] [help]", "Prints this list of commands"));
            sender.sendMessage(MainCommand.formatCommandDescription("doc[s] cat[[egorie]s]", "Prints a list of the documentation categories"));
            sender.sendMessage(MainCommand.formatCommandDescription("doc[s] all [page]", "Lists a page of all syntax elements"));
            sender.sendMessage(MainCommand.formatCommandDescription("doc[s] <elem type> [page]", "Lists a page of all syntax elements of a certain type"));
            sender.sendMessage(MainCommand.formatCommandDescription("doc[s] <category> [elem type] [page]", "Lists a page of syntax elements in that category, either all of them or of a specific type"));
            sender.sendMessage(MainCommand.formatCommandDescription("doc[s] <elem name>", "Lists the documentation for a specific syntax element"));
            sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "Accepted Element Types: " + MainCommand.ALT_CHAT_COLOR + "Effect Condition Expression Event Type Scope");
            return true;
        }
        if (args[1].equalsIgnoreCase("generatefile")) {
            sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "The documentation file will now be generated. This command is not intended to be executed by people other than the developer. The file generated will probably not be suitable for use as documentation itself and is intended to be used to import documentation into online Skript documentation sites such as skUnity and Skript Hub. If you would like to view MundoSK's documentation, use the " + MainCommand.ALT_CHAT_COLOR + "/mundosk doc" + MainCommand.PRIMARY_CHAT_COLOR + " command or visit one of these websites.");
            try {
                DocumentationFileGenerator.generateDocumentationFile();
                sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "MundoSK has successfully generated the documentation file.");
                return true;
            }
            catch (IOException e) {
                sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "An error occurred while generating the documentation file. See the console for details.");
                Logging.reportException(DocumentationCommand.class, e);
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("cat") || args[1].equalsIgnoreCase("cats") || args[1].equalsIgnoreCase("categories")) {
            if (args.length > 2) {
                return false;
            }
            sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "Documentation Categories");
            for (String category : Documentation.getCategories()) {
                sender.sendMessage(MainCommand.ALT_CHAT_COLOR + category);
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("all")) {
            if (args.length == 2) {
                DocumentationCommand.displayElems(sender, Documentation.getAllElements(), "All Syntax Elements", 1, true, true);
                return true;
            }
            if (args.length != 3) return false;
            Optional<Integer> pageOptional = Utilities.parseIntOptional(args[2]);
            if (!pageOptional.isPresent()) return false;
            DocumentationCommand.displayElems(sender, Documentation.getAllElements(), "All Syntax Elements", pageOptional.get(), true, true);
            return true;
        }
        Optional<ImmutableGroupedList<? extends DocumentationElement, String>> docElemGroupedListOptional = DocumentationCommand.getDocElemGroupedList(args[1]);
        if (docElemGroupedListOptional.isPresent()) {
            ImmutableGroupedList<? extends DocumentationElement, String> docElemGroupedList = docElemGroupedListOptional.get();
            if (args.length == 2) {
                DocumentationCommand.displayElems(sender, docElemGroupedList, "All " + Utilities.capitalize(args[1]), 1, true, false);
                return true;
            }
            if (args.length != 3) return false;
            Optional<Integer> pageOptional = Utilities.parseIntOptional(args[2]);
            if (!pageOptional.isPresent()) return false;
            DocumentationCommand.displayElems(sender, docElemGroupedList, "All " + Utilities.capitalize(args[1]), pageOptional.get(), true, false);
            return true;
        }
        Optional<String> categoryOptional = Utilities.binarySearchList(Documentation.getCategories(), args[1].toLowerCase(), (s, s2) -> s.compareTo(s2.toLowerCase()));
        if (!categoryOptional.isPresent()) return false;
        String category = categoryOptional.get();
        if (args.length == 2) {
            DocumentationCommand.displayElems(sender, Documentation.getAllElements().getGroup(category), category + " Syntax Elements", 1, false, true);
            return true;
        }
        if (args.length == 3) {
            Optional<Integer> pageOptional = Utilities.parseIntOptional(args[2]);
            if (pageOptional.isPresent()) {
                DocumentationCommand.displayElems(sender, Documentation.getAllElements().getGroup(category), category + " Syntax Elements", pageOptional.get(), false, true);
                return true;
            }
        } else if (args.length > 4) {
            return false;
        }
        if (args.length == 4) {
            Optional<Integer> pageOptional = Utilities.parseIntOptional(args[3]);
            if (!pageOptional.isPresent()) return false;
            page = pageOptional.get();
            return DocumentationCommand.getDocElemGroupedList(args[2]).map(docElemMultimap -> {
                DocumentationCommand.displayElems(sender, docElemMultimap.getGroup(category), category + " " + Utilities.capitalize(args[2]) + "s", page, false, false);
                return true;
            }).orElse(false);
        } else {
            page = 1;
        }
        return DocumentationCommand.getDocElemGroupedList(args[2]).map(docElemMultimap -> {
            DocumentationCommand.displayElems(sender, docElemMultimap.getGroup(category), category + " " + Utilities.capitalize(args[2]) + "s", page, false, false);
            return true;
        }).orElse(false);
    }

    private static Optional<ImmutableGroupedList<? extends DocumentationElement, String>> getDocElemGroupedList(String elemType) {
        if (Character.toLowerCase(elemType.charAt(elemType.length() - 1)) == 's') {
            elemType = elemType.substring(0, elemType.length() - 1);
        }
        switch (elemType.toLowerCase()) {
            case "effect": {
                return Optional.of(Documentation.getEffects());
            }
            case "condition": {
                return Optional.of(Documentation.getConditions());
            }
            case "expression": {
                return Optional.of(Documentation.getExpressions());
            }
            case "event": {
                return Optional.of(Documentation.getEvents());
            }
            case "type": {
                return Optional.of(Documentation.getTypes());
            }
            case "scope": {
                return Optional.of(Documentation.getScopes());
            }
        }
        return Optional.empty();
    }

    private static void displayElems(CommandSender sender, List<? extends DocumentationElement> docElems, String header, int page, boolean displayCategory, boolean displayType) {
        int pages = 1 + (docElems.size() - 1) / 12;
        if (page > pages || page < 1) {
            sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "Invalid page number " + MainCommand.ALT_CHAT_COLOR + page + MainCommand.PRIMARY_CHAT_COLOR + ", there are " + MainCommand.ALT_CHAT_COLOR + pages + MainCommand.PRIMARY_CHAT_COLOR + " pages of " + header);
            return;
        }
        sender.sendMessage(MainCommand.PRIMARY_CHAT_COLOR + "Page " + page + " of " + pages + " of " + header);
        int max = page * 12;
        int min = max - 12;
        max = Math.min(max, docElems.size());
        for (int i = min; i < max; ++i) {
            DocumentationElement docElem = docElems.get(i);
            sender.sendMessage(MainCommand.TRI_CHAT_COLOR + (displayCategory ? docElem.category + " " : "") + (displayType ? (Object)((Object)docElem.getType()) + " " : "") + MainCommand.ALT_CHAT_COLOR + docElem.name);
        }
    }
}

