/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.Tab;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class SimpleTab
extends Tab {
    public final String uuidEnding;
    private Optional<String> priority;
    public static final String SPACES = "            ";
    public static final String UUID_BEGINNING = "10001000-1000-3000-8000-20002000";

    public SimpleTab(SimpleTablist simpleTablist, String id, @Nullable String priority, String uuidEnding, @Nullable String displayName, @Nullable Integer latencyBars, @Nullable Skin icon, @Nullable Integer score) {
        super(simpleTablist.tablist, (id + SPACES).substring(0, 12) + "#M" + uuidEnding, UUID.fromString("10001000-1000-3000-8000-2000200010" + uuidEnding), displayName, latencyBars, icon, score);
        this.uuidEnding = uuidEnding;
        this.priority = Optional.ofNullable(priority);
    }

    @Override
    public String getName() {
        return this.priority.map(str -> str + SPACES.substring(12 - str.length()) + "#M" + this.uuidEnding).orElse(this.name);
    }

    public Optional<String> getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable String priority) {
        if (priority != null && (priority.length() > 12 || priority.endsWith(" "))) {
            throw new IllegalArgumentException("The priority must be at most 12 characters in length and not end in a space, priority = \"" + priority + "\" (quoted to show spaces if they exist)");
        }
        if (OptionalUtil.equal(priority, this.priority)) {
            return;
        }
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        this.priority = Optional.ofNullable(priority);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
    }

    public void applyChanges(SimpleTab otherTab) {
        boolean needsRefresh;
        if (otherTab == null) {
            throw new IllegalArgumentException("The otherTab = " + otherTab + " should not be null");
        }
        this.getScore().ifPresent(otherTab::setScore);
        boolean bl = needsRefresh = this.icon.isPresent() && !OptionalUtil.referencesEqual(this.icon.get(), otherTab.getIcon()) || this.priority.isPresent() && !OptionalUtil.equal(this.priority.get(), otherTab.getPriority());
        if (needsRefresh) {
            this.priority.ifPresent(val -> {
                otherTab.priority = Optional.of(val);
            });
            this.displayName.ifPresent(val -> {
                otherTab.displayName = Optional.of(val);
            });
            this.latencyBars.ifPresent(val -> {
                otherTab.latencyBars = Optional.of(val);
            });
            this.priority.ifPresent(val -> {
                otherTab.priority = Optional.of(val);
            });
            this.icon.ifPresent(val -> {
                otherTab.icon = Optional.of(val);
            });
            otherTab.refresh();
            if (otherTab.tablist.areScoresEnabled()) {
                this.tablist.sendPacket(otherTab.updateScorePacket(), this);
            }
        } else {
            this.displayName.ifPresent(otherTab::setDisplayName);
            this.latencyBars.ifPresent(otherTab::setLatencyBars);
        }
    }
}

