/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib.Alias;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Core.Static.Reflection;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.Util.Skript.BaseEvent;
import java.util.Iterator;
import java.util.Optional;
import org.bukkit.event.Event;

public class PacketInfoAlias {
    public final PacketType packetType;
    public final String alias;
    public final String original;
    public final Expression<?> expression;
    public static final Reflection.MethodInvoker SKRIPT_PARSER_PARSE = Reflection.getMethod(SkriptParser.class, "parse", Iterator.class);

    private PacketInfoAlias(PacketType packetType, String alias, String original, Expression<?> expression) {
        this.packetType = packetType;
        this.alias = alias;
        this.expression = expression;
        this.original = original;
    }

    public static Optional<PacketInfoAlias> create(PacketType packetType, String syntax, String original) {
        String resultSyntax = original.replace("%packet%", "event-packet");
        String currentEventName = ScriptLoader.getCurrentEventName();
        Class[] currentEvents = ScriptLoader.getCurrentEvents();
        ScriptLoader.setCurrentEvent((String)"ExprPacketInfoAliasPacketEvent", (Class[])new Class[]{ContainerEvent.class});
        Logging.debug(PacketInfoAlias.class, "packetType = " + packetType + ", syntax = " + syntax + ", original = " + original + ", resultSyntax = " + resultSyntax);
        Expression<?> expression = PacketInfoAlias.parsePacketInfoExpression(resultSyntax, "'" + original + "' is not a valid packet info expression");
        Logging.debug(PacketInfoAlias.class, "expr = " + expression);
        ScriptLoader.setCurrentEvent((String)currentEventName, (Class[])currentEvents);
        if (expression == null) {
            return Optional.empty();
        }
        return Optional.of(new PacketInfoAlias(packetType, syntax, original, expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Expression<?> parsePacketInfoExpression(String syntax, String defaultError) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            SkriptParser parser = new SkriptParser(syntax, 3);
            Expression result = (Expression)SKRIPT_PARSER_PARSE.invoke(parser, PacketManager.packetInfoExpressionInfoIterator());
            if (result != null) {
                log.printLog();
                Expression expression = result;
                return expression;
            }
            log.printError(defaultError);
            Expression<?> expression = null;
            return expression;
        }
        catch (Exception e) {
            Logging.reportException(PacketInfoAlias.class, e);
        }
        finally {
            log.stop();
        }
        return null;
    }

    public String toString(Expression<PacketContainer> packetExpression, Event event, boolean b) {
        return this.alias.replace("%packet%", packetExpression.toString(event, b));
    }

    public Object[] get(PacketContainer packet) {
        if (packet.getType() == this.packetType) {
            return this.expression.getArray((Event)new ContainerEvent(packet));
        }
        return new Object[0];
    }

    public void change(PacketContainer packet, Object[] delta, Changer.ChangeMode mode) {
        if (packet.getType() == this.packetType) {
            ContainerEvent event = new ContainerEvent(packet);
            this.expression.change((Event)event, delta, mode);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return this.expression.acceptChange(mode);
    }

    public static class ContainerEvent
    extends BaseEvent {
        public final PacketContainer packet;

        public ContainerEvent(PacketContainer packet) {
            this.packet = packet;
        }
    }
}

