/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Collections;

import com.pie.tlatoani.Core.Static.Logging;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;

public class ChangePermissiveTreeIterator<K, V>
implements Iterator<V> {
    private final TreeMap<K, V> treeMap;
    private K nextKey = null;
    private V nextValue = null;
    private ChangePermissiveTreeIterator<K, V> subIterator = null;
    private Optional<Boolean> hasNext = Optional.empty();

    public ChangePermissiveTreeIterator(TreeMap<K, V> treeMap) {
        this.treeMap = treeMap;
    }

    @Override
    public boolean hasNext() {
        Map.Entry<K, V> nextEntry;
        Logging.debug((Object)this, this + "hasNext() called, nextKey = " + this.nextKey + ", nextValue = " + this.nextValue + ", subIterator = " + this.subIterator + ", hasNext = " + this.hasNext);
        if (this.hasNext.isPresent()) {
            return this.hasNext.get();
        }
        if (this.subIterator != null && this.subIterator.hasNext() && this.subIterator.treeMap == this.treeMap.get(this.nextKey)) {
            Logging.debug((Object)this, this + "hasNext(): subIterator continues");
            this.nextValue = this.subIterator.next();
            this.hasNext = Optional.of(true);
            return true;
        }
        Logging.debug((Object)this, this + "hasNext(): subIterator ends");
        Logging.debug((Object)this, this + "hasNext(): getting next value");
        Map.Entry<K, V> entry = nextEntry = this.nextKey == null ? this.treeMap.firstEntry() : this.treeMap.higherEntry(this.nextKey);
        if (nextEntry == null) {
            this.nextKey = null;
            this.nextValue = null;
            Logging.debug((Object)this, this + "hasNext(): returning false");
            this.hasNext = Optional.of(false);
            return false;
        }
        this.nextKey = nextEntry.getKey();
        if (nextEntry.getValue() instanceof TreeMap) {
            this.subIterator = new ChangePermissiveTreeIterator<K, V>((TreeMap)nextEntry.getValue());
            Logging.debug((Object)this, this + "hasNext(): testing new subIterator");
            return this.hasNext();
        }
        this.nextValue = nextEntry.getValue();
        Logging.debug((Object)this, this + "hasNext(): returning true");
        this.hasNext = Optional.of(true);
        return true;
    }

    @Override
    public V next() {
        Logging.debug((Object)this, this + "next() called, nextKey = " + this.nextKey + ", nextValue = " + this.nextValue + ", subIterator = " + this.subIterator + ", hasNext = " + this.hasNext);
        if (!this.hasNext()) {
            throw new NoSuchElementException("Called next() on a TreeIterator without a next element");
        }
        this.hasNext = Optional.empty();
        return this.nextValue;
    }

    public String getBranch() {
        if (this.subIterator == null) {
            return this.nextKey.toString();
        }
        return this.nextKey + "::" + this.subIterator.getBranch();
    }
}

