/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Core.Static.MathUtil;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.Simple.SimpleTab;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.IntUsage;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;

public class SimpleTablist
implements SupplementaryTablist<SimpleTablist> {
    public final Tablist tablist;
    private final PlayerTablist playerTablist;
    private final HashMap<String, SimpleTab> tabs = new HashMap();
    private final IntUsage intUsage = new IntUsage(256);
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String UUID_BEGINNING = "10001000-1000-3000-8000-20002000";

    public SimpleTablist(PlayerTablist playerTablist) {
        this.tablist = playerTablist.tablist;
        this.playerTablist = playerTablist;
    }

    public void clear() {
        for (Tab tab : this.tabs.values()) {
            this.tablist.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        }
        this.tabs.clear();
    }

    public SimpleTab createTab(String id, SimpleTab.Location location, String priority, @Nullable String displayName, @Nullable Integer latencyBars, @Nullable Skin icon, @Nullable Integer score) {
        if (id == null || priority == null || location == null) {
            throw new IllegalArgumentException("The id, priority, and location cannot be null: id = " + id + ", priority = " + priority + ", location = " + (Object)((Object)location));
        }
        if (priority.length() > 12) {
            throw new IllegalArgumentException("The priority must be at most 12 characters in length, priority = " + priority);
        }
        return this.tabs.compute(id, (__, oldTab) -> {
            if (oldTab != null) {
                this.tablist.sendPacket(oldTab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
            }
            int num = this.intUsage.useFirstUnused() - 1;
            String uuidEnding = MathUtil.toHexDigit(num / 16) + "" + MathUtil.toHexDigit(num % 16);
            SimpleTab newTab = new SimpleTab(this, id, location, priority, uuidEnding, displayName, latencyBars, icon, score);
            this.tablist.sendPacket(newTab.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
            if (this.tablist.areScoresEnabled()) {
                this.tablist.sendPacket(newTab.updateScorePacket(), this);
            }
            return newTab;
        });
    }

    public Optional<SimpleTab> getTab(String id) {
        return Optional.ofNullable(this.tabs.get(id));
    }

    public void deleteTab(String id) {
        Tab tab = this.tabs.remove(id);
        if (tab != null) {
            this.tablist.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        }
    }

    public boolean isEmpty() {
        return this.tabs.isEmpty();
    }

    @Override
    public void disable() {
        this.clear();
    }

    @Override
    public boolean allowExternalPlayerTabModification() {
        return true;
    }

    @Override
    public SimpleTablist basicClone(PlayerTablist otherPlayerTablist) {
        return new SimpleTablist(otherPlayerTablist);
    }

    @Override
    public void applyChanges(SimpleTablist simpleTablist) {
        this.tabs.forEach((id, tab) -> OptionalUtil.consume(simpleTablist.getTab((String)id), () -> simpleTablist.createTab((String)id, tab.getLocation().orElse(null), tab.getPriority().orElse(null), tab.getDisplayName().orElse(null), tab.getLatencyBars().orElse(null), tab.getIcon().orElse(null), tab.getScore().orElse(null)), tab::applyChanges));
    }

    @Override
    public void refreshIconsIfDefault() {
        for (Tab tab : this.tabs.values()) {
            if (tab.getIcon().isPresent()) continue;
            tab.refresh();
        }
    }
}

