/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class SimpleTab
extends Tab {
    private final String id;
    private final String uuidEnding;
    private Optional<Location> location;
    private Optional<String> priority;

    public SimpleTab(SimpleTablist simpleTablist, String id, @Nullable Location location, @Nullable String priority, String uuidEnding, @Nullable String displayName, @Nullable Integer latencyBars, @Nullable Skin icon, @Nullable Integer score) {
        super(simpleTablist.tablist, "SimpleTab-" + uuidEnding, UUID.fromString("10001000-1000-3000-8000-2000200010" + uuidEnding), displayName, latencyBars, icon, score);
        this.id = id;
        this.uuidEnding = uuidEnding;
    }

    public String getName() {
        String priority = this.priority.orElse(this.id.length() < 12 ? this.id : this.id.substring(0, 12));
        switch (this.location.orElse(Location.WITHIN_PLAYERS)) {
            case WITHIN_PLAYERS: {
                return priority + "#M" + this.uuidEnding;
            }
            case BEFORE_PLAYERS: {
                return "#M" + priority + this.uuidEnding;
            }
            case AFTER_PLAYERS: {
                return "~M" + priority + this.uuidEnding;
            }
        }
        throw new IllegalStateException("location = " + this.location);
    }

    @Override
    public PacketContainer playerInfoPacket(EnumWrappers.PlayerInfoAction action) {
        if (action == null) {
            throw new IllegalArgumentException("The action = " + action + " should not be null");
        }
        return PacketUtil.playerInfoPacket(this.displayName.orElse(""), this.latencyBars.orElse(5), null, this.getName(), this.uuid, this.icon.orElse(this.tablist.getDefaultIcon().orElse(Tablist.DEFAULT_SKIN_TEXTURE)), action);
    }

    @Override
    public PacketContainer updateScorePacket() {
        return PacketUtil.scorePacket(this.getName(), "MundoSK_Tablist", this.getScore().orElse(0), EnumWrappers.ScoreboardAction.CHANGE);
    }

    public Optional<Location> getLocation() {
        return this.location;
    }

    public Optional<String> getPriority() {
        return this.priority;
    }

    public void setLocation(@Nullable Location location) {
        if (OptionalUtil.equal(location, this.location)) {
            return;
        }
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        this.location = Optional.ofNullable(location);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
    }

    public void setPriority(@Nullable String priority) {
        if (priority != null && priority.length() > 12) {
            throw new IllegalArgumentException("The priority must be non-null and at most 12 characters in length, priority = " + priority);
        }
        if (OptionalUtil.equal(priority, this.priority)) {
            return;
        }
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        this.priority = Optional.ofNullable(priority);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
    }

    public void applyChanges(SimpleTab otherTab) {
        boolean needsRefresh;
        if (otherTab == null) {
            throw new IllegalArgumentException("The otherTab = " + otherTab + " should not be null");
        }
        this.getScore().ifPresent(otherTab::setScore);
        boolean bl = needsRefresh = this.icon.isPresent() && !OptionalUtil.referencesEqual(this.icon.get(), otherTab.getIcon()) || this.location.isPresent() && OptionalUtil.equal(this.location.get(), otherTab.getLocation()) || this.priority.isPresent() && OptionalUtil.equal(this.priority.get(), otherTab.getPriority());
        if (needsRefresh) {
            this.displayName.ifPresent(val -> {
                otherTab.displayName = Optional.of(val);
            });
            this.latencyBars.ifPresent(val -> {
                otherTab.latencyBars = Optional.of(val);
            });
            this.location.ifPresent(val -> {
                otherTab.location = Optional.of(val);
            });
            this.priority.ifPresent(val -> {
                otherTab.priority = Optional.of(val);
            });
            this.icon.ifPresent(val -> {
                otherTab.icon = Optional.of(val);
            });
            otherTab.refresh();
            if (otherTab.tablist.areScoresEnabled()) {
                this.tablist.sendPacket(otherTab.updateScorePacket(), this);
            }
        } else {
            this.displayName.ifPresent(otherTab::setDisplayName);
            this.latencyBars.ifPresent(otherTab::setLatencyBars);
        }
    }

    public static enum Location {
        BEFORE_PLAYERS,
        WITHIN_PLAYERS,
        AFTER_PLAYERS;

    }
}

