/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Static;

import com.pie.tlatoani.Mundo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;

public final class Config {
    private static final List<Option> options = new ArrayList<Option>();
    public static final Option<List<String>> DEBUG_PACKAGES = new Option("debug", Arrays.asList(new String[0]), MemorySection::getStringList);
    public static final Option<Boolean> IMPLEMENT_PACKET_STUFF = new Option("enable_custom_skin_and_tablist", true, MemorySection::getBoolean);
    public static final Option<Integer> TABLIST_SPAWN_REMOVE_TAB_DELAY = new Option("tablist_remove_tab_delay_spawn", 5, MemorySection::getInt);
    public static final Option<Integer> TABLIST_RESPAWN_REMOVE_TAB_DELAY = new Option("tablist_remove_tab_delay_respawn", 5, MemorySection::getInt);
    public static final Option<Boolean> DISABLE_SIZE_SYNTAX = new Option("border_disable_size_syntax", false, MemorySection::getBoolean);

    public static void reload() {
        Mundo.get().reloadConfig();
        FileConfiguration config = Mundo.get().getConfig();
        options.forEach(option -> ((Option)option).addDefault(config));
        config.options().copyDefaults(true);
        options.forEach(option -> ((Option)option).loadValue(config));
        Mundo.get().saveConfig();
    }

    public static void displayConfig(CommandSender sender) {
        for (Option option : options) {
            sender.sendMessage(Mundo.formatMundoSKInfo(option.path, option.getCurrentValue().toString()));
        }
    }

    public static class Option<T> {
        public final String path;
        private final T defaultValue;
        private final BiFunction<FileConfiguration, String, T> function;
        private T currentValue = null;

        private Option(String path, T defaultValue, BiFunction<FileConfiguration, String, T> function) {
            this.path = path;
            this.defaultValue = defaultValue;
            this.function = function;
            options.add(this);
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        private void addDefault(FileConfiguration config) {
            config.addDefault(this.path, this.defaultValue);
        }

        private void loadValue(FileConfiguration config) {
            this.currentValue = this.function.apply(config, this.path);
        }
    }
}

