/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util;

import com.pie.tlatoani.Core.Static.MathUtil;

public class IntUsage {
    private final int amount;
    private final int[] array;

    public IntUsage(int amount) {
        this.amount = amount;
        this.array = new int[(amount + 29) / 30];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = 0x7FFFFFFE;
        }
    }

    public boolean isUsed(int n) {
        if (!MathUtil.isInRange(1.0, n, this.amount)) {
            throw new IllegalArgumentException("n = " + n + ", should be within range 1 to " + this.amount + " (inclusive)");
        }
        return (this.array[(n - 1) / 30] & 1 << n) == 0;
    }

    public void setUsed(int n) {
        if (!MathUtil.isInRange(1.0, n, this.amount)) {
            throw new IllegalArgumentException("n = " + n + ", should be within range 1 to " + this.amount + " (inclusive)");
        }
        if (!this.isUsed(n)) {
            int n2 = (n - 1) / 30;
            this.array[n2] = this.array[n2] - (1 << n);
        }
    }

    public void setUnused(int n) {
        if (!MathUtil.isInRange(1.0, n, this.amount)) {
            throw new IllegalArgumentException("n = " + n + ", should be within range 1 to " + this.amount + " (inclusive)");
        }
        int n2 = (n - 1) / 30;
        this.array[n2] = this.array[n2] | 1 << n;
    }

    public int getFirstUnused() {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == 0) continue;
            int result = MathUtil.binaryLog(this.array[i] & -this.array[i]);
            if (result > this.amount) break;
            return result;
        }
        return -1;
    }

    public int useFirstUnused() {
        int result = this.getFirstUnused();
        if (result != -1) {
            this.setUsed(result);
        }
        return result;
    }
}

