/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Array;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pie.tlatoani.Core.Static.MathUtil;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.Tablist.Array.ArrayTablist;
import com.pie.tlatoani.Tablist.Group.TablistProvider;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import java.util.Optional;
import org.bukkit.event.Event;

public class ExprLatencyBarsOfArrayTab
extends SimpleExpression<Number> {
    private Expression<Number> column;
    private Expression<Number> row;
    private TablistProvider tablistProvider;

    protected Number[] get(Event event) {
        int column = Optional.ofNullable(this.column.getSingle(event)).map(Number::intValue).orElse(-1);
        int row = Optional.ofNullable(this.row.getSingle(event)).map(Number::intValue).orElse(-1);
        return (Number[])this.tablistProvider.view(event).map(tablist -> OptionalUtil.cast(tablist.getSupplementaryTablist(), ArrayTablist.class).filter(arrayTablist -> MathUtil.isInRange(1.0, column, arrayTablist.getColumns())).filter(arrayTablist -> MathUtil.isInRange(1.0, row, arrayTablist.getRows())).map(arrayTablist -> arrayTablist.getTab(column, row)).flatMap(Tab::getLatencyBars).orElse(null)).toArray(Number[]::new);
    }

    public boolean isSingle() {
        return this.tablistProvider.isSingle();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString("latency bars of array tab " + this.column + ", " + this.row + " [for %]");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.column = expressions[0];
        this.row = expressions[1];
        this.tablistProvider = TablistProvider.of(expressions, 2);
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Integer value;
        int column = Optional.ofNullable(this.column.getSingle(event)).map(Number::intValue).orElse(-1);
        int row = Optional.ofNullable(this.row.getSingle(event)).map(Number::intValue).orElse(-1);
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            if (delta[0] == null) {
                return;
            }
            value = ((Number)delta[0]).intValue() * (mode == Changer.ChangeMode.ADD ? 1 : -1);
        } else {
            value = mode == Changer.ChangeMode.SET && delta[0] != null ? Integer.valueOf(MathUtil.limitToRange(0, ((Number)delta[0]).intValue(), 5)) : null;
        }
        for (Tablist tablist : this.tablistProvider.get(event)) {
            ArrayTablist arrayTablist;
            if (!(tablist.getSupplementaryTablist() instanceof ArrayTablist) || !MathUtil.isInRange(1.0, column, (arrayTablist = (ArrayTablist)tablist.getSupplementaryTablist()).getColumns()) || !MathUtil.isInRange(1.0, row, arrayTablist.getRows())) continue;
            Tab tab = arrayTablist.getTab(column, row);
            if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
                tab.getLatencyBars().ifPresent(original -> tab.setLatencyBars(MathUtil.limitToRange(0, original + value, 5)));
                continue;
            }
            tab.setLatencyBars(value);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

