/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.SkriptEventInfo;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Core.Static.Reflection;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringJoiner;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class TestEventConstruction {
    public static void test() {
        try {
            Collection skriptEvents = (Collection)Reflection.getStaticField(Skript.class, "events");
            HashSet<Class> successfulEventClasses = new HashSet<Class>();
            HashSet<Class> failedEventClasses = new HashSet<Class>();
            for (SkriptEventInfo skriptEventInfo : skriptEvents) {
                for (Class eventClass : skriptEventInfo.events) {
                    if (successfulEventClasses.contains(eventClass) || failedEventClasses.contains(eventClass)) continue;
                    if (TestEventConstruction.testEventClass(eventClass)) {
                        successfulEventClasses.add(eventClass);
                        continue;
                    }
                    failedEventClasses.add(eventClass);
                }
            }
            Logging.debug(TestEventConstruction.class, "Out of " + (successfulEventClasses.size() + failedEventClasses.size()) + " event classes,");
            Logging.debug(TestEventConstruction.class, successfulEventClasses.size() + " succeeded and " + failedEventClasses.size() + " failed.");
            Logging.debug(TestEventConstruction.class, "The failures were " + failedEventClasses);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logging.reportException(TestEventConstruction.class, e);
        }
    }

    private static boolean testEventClass(Class<? extends Event> eventClass) {
        for (Constructor<?> constructor : eventClass.getConstructors()) {
            try {
                Object[] parameters = new Object[constructor.getParameterCount()];
                Class<?>[] paramTypes = constructor.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    Class<?> paramType = paramTypes[i];
                    if (paramType == Boolean.TYPE || paramType == Boolean.class) {
                        parameters[i] = true;
                        continue;
                    }
                    if (paramType == Integer.TYPE || paramType == Integer.class || paramType == Number.class) {
                        parameters[i] = 0;
                        continue;
                    }
                    if (paramType == Long.TYPE || paramType == Integer.class) {
                        parameters[i] = 0L;
                        continue;
                    }
                    if (paramType == Double.TYPE || paramType == Double.class) {
                        parameters[i] = 0.0;
                        continue;
                    }
                    if (paramType == Short.TYPE || paramType == Short.class) {
                        parameters[i] = (short)0;
                        continue;
                    }
                    if (paramType == Float.TYPE || paramType == Float.class) {
                        parameters[i] = Float.valueOf(0.0f);
                        continue;
                    }
                    if (paramType == Byte.TYPE || paramType == Byte.class) {
                        parameters[i] = (byte)0;
                        continue;
                    }
                    if (paramType == String.class) {
                        parameters[i] = "abcd";
                        continue;
                    }
                    if (paramType.isArray()) {
                        parameters[i] = Array.newInstance(paramType.getComponentType(), 1);
                        continue;
                    }
                    if (!paramType.isEnum()) continue;
                    parameters[i] = paramType.getEnumConstants()[0];
                }
                Object creation = constructor.newInstance(parameters);
                StringJoiner logBuilder = new StringJoiner(", ", ChatColor.DARK_GREEN + "Success, creation: " + creation + ", constructor: " + eventClass.getName() + "(", ")");
                for (Class<?> paramType : paramTypes) {
                    logBuilder.add(paramType.getName());
                }
                Logging.debug(TestEventConstruction.class, logBuilder.toString());
                return true;
            }
            catch (Exception e) {
                StringJoiner logBuilder = new StringJoiner(", ", "Exception, constructor: " + eventClass.getName() + "(", ")");
                for (Class<?> paramType : constructor.getParameterTypes()) {
                    logBuilder.add(paramType.getName());
                }
                Logging.debug(TestEventConstruction.class, logBuilder.toString());
                Logging.debug(TestEventConstruction.class, e);
            }
        }
        Logging.debug(TestEventConstruction.class, ChatColor.RED + "Failure for class " + eventClass.getName());
        return false;
    }
}

