/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin.MineSkin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.pie.tlatoani.Core.Static.Config;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Core.Static.Scheduling;
import com.pie.tlatoani.Skin.MineSkin.MineSkinClient;
import com.pie.tlatoani.Skin.ProfileManager;
import com.pie.tlatoani.Skin.Skin;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import mundosk_libraries.light_jsoup.Connection;
import mundosk_libraries.light_jsoup.HttpConnection;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PlayerSkinRetrieval {
    public static final String MOJANG_FROM_UUID = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static Cache<UUID, Skin> skinCache = null;

    private static synchronized Cache<UUID, Skin> skinCache(boolean set, Cache<UUID, Skin> newCache) {
        if (set) {
            skinCache = newCache;
        }
        return skinCache;
    }

    public static void reloadSkinCache() {
        if (Config.IMPLEMENT_PACKET_STUFF.getCurrentValue().booleanValue() && Config.ENABLE_OFFLINE_PLAYER_SKIN_CACHE.getCurrentValue().booleanValue()) {
            CacheBuilder builder = CacheBuilder.newBuilder();
            builder.maximumSize((long)Config.OFFLINE_PLAYER_SKIN_CACHE_MAX_SIZE.getCurrentValue().intValue());
            builder.expireAfterAccess((long)Config.OFFLINE_PLAYER_SKIN_CACHE_EXPIRE_TIME_MINUTES.getCurrentValue().intValue(), TimeUnit.MINUTES);
            PlayerSkinRetrieval.skinCache(true, (Cache<UUID, Skin>)builder.build());
        } else {
            PlayerSkinRetrieval.skinCache(true, null);
        }
    }

    public static Skin retrieveSkin(OfflinePlayer offlinePlayer, int timeoutMillis) {
        try {
            Skin skin;
            Cache<UUID, Skin> skinCache = PlayerSkinRetrieval.skinCache(false, null);
            UUID uuid = offlinePlayer.getUniqueId();
            Skin skin2 = skin = skinCache == null ? null : (Skin)skinCache.getIfPresent((Object)uuid);
            if (skin == null) {
                Skin[] array = new Skin[]{};
                Scheduling.syncLock(() -> {
                    if (offlinePlayer.isOnline()) {
                        array[0] = ProfileManager.getProfile(offlinePlayer.getPlayer()).getActualSkin();
                    }
                });
                skin = array[0];
                if (skin == null && (skin = PlayerSkinRetrieval.fromMojangString(uuid, PlayerSkinRetrieval.mojangFromUUID(uuid, timeoutMillis))) != null && skinCache != null) {
                    skinCache.put((Object)uuid, (Object)skin);
                }
            }
            return skin;
        }
        catch (IOException | ParseException e) {
            Logging.debug(PlayerSkinRetrieval.class, (Exception)e);
            return null;
        }
    }

    public static Skin retrieveOfflineSkin(OfflinePlayer offlinePlayer, int timeoutMillis) {
        try {
            Skin skin;
            Cache<UUID, Skin> skinCache = PlayerSkinRetrieval.skinCache(false, null);
            UUID uuid = offlinePlayer.getUniqueId();
            Skin skin2 = skin = skinCache == null ? null : (Skin)skinCache.getIfPresent((Object)uuid);
            if (skin == null && (skin = PlayerSkinRetrieval.fromMojangString(uuid, PlayerSkinRetrieval.mojangFromUUID(uuid, timeoutMillis))) != null && skinCache != null) {
                skinCache.put((Object)uuid, (Object)skin);
            }
            return skin;
        }
        catch (IOException | ParseException e) {
            Logging.debug(PlayerSkinRetrieval.class, (Exception)e);
            return null;
        }
    }

    private static Skin fromMojangString(UUID uuid, String string) throws ParseException {
        Logging.debug(MineSkinClient.class, "fromMojangString(uuid = " + uuid + ", string = " + string + ")");
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(string);
        if (jsonObject.containsKey((Object)"error")) {
            Logging.debug(MineSkinClient.class, "fromMojangString() error: " + jsonObject.get((Object)("error, message: " + jsonObject.get((Object)"errorMessage"))));
            return null;
        }
        JSONObject subJSON = (JSONObject)jsonObject.get((Object)"properties");
        return Skin.fromJSON(subJSON, uuid);
    }

    private static String mojangFromUUID(UUID uuid, int timeoutMillis) throws IOException {
        Connection connection = HttpConnection.connect(String.format(MOJANG_FROM_UUID, uuid.toString())).method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).timeout(timeoutMillis);
        return connection.execute().body();
    }
}

