/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin.MineSkin;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.pie.tlatoani.Skin.MineSkin.MineSkinClient;
import com.pie.tlatoani.Skin.MineSkin.PlayerSkinRetrieval;
import com.pie.tlatoani.Skin.Skin;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

public class ExprRetrievedSkin
extends SimpleExpression<Skin> {
    Expression<String> stringExpr;
    Expression<OfflinePlayer> offlinePlayerExpr;
    Expression<Timespan> timeoutExpr;
    RetrieveMode mode;
    boolean def;
    public static final int DEFAULT_TIMEOUT_MILLIS = 10000;

    Skin getSkin(Event event) {
        int timeoutMillis = this.timeoutExpr == null ? 10000 : new Long(((Timespan)this.timeoutExpr.getSingle(event)).getMilliSeconds()).intValue();
        switch (this.mode) {
            case FILE: {
                return MineSkinClient.fromMineSkinString(MineSkinClient.mineSkinFromFile(new File((String)this.stringExpr.getSingle(event)), timeoutMillis, this.def));
            }
            case URL: {
                return MineSkinClient.fromMineSkinString(MineSkinClient.mineSkinFromUrl((String)this.stringExpr.getSingle(event), timeoutMillis, this.def));
            }
            case OFFLINE_PLAYER: {
                return PlayerSkinRetrieval.retrieveSkin((OfflinePlayer)this.offlinePlayerExpr.getSingle(event), timeoutMillis);
            }
            case UUID: {
                return PlayerSkinRetrieval.retrieveSkin(Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)this.stringExpr.getSingle(event))), timeoutMillis);
            }
        }
        throw new IllegalStateException("RetrieveMode = " + (Object)((Object)this.mode));
    }

    protected Skin[] get(Event event) {
        return new Skin[]{this.getSkin(event)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Skin> getReturnType() {
        return Skin.class;
    }

    public String toString(Event event, boolean b) {
        switch (this.mode) {
            case FILE: {
                return "retrieved " + (this.def ? "" : "slim ") + "skin from file " + this.stringExpr;
            }
            case URL: {
                return "retrieved " + (this.def ? "" : "slim ") + "skin from url " + this.stringExpr;
            }
            case OFFLINE_PLAYER: {
                return "retrieved skin of " + this.offlinePlayerExpr;
            }
            case UUID: {
                return "retrieved skin from uuid " + this.stringExpr;
            }
        }
        throw new IllegalStateException("RetrieveMode = " + (Object)((Object)this.mode));
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.mode = RetrieveMode.values()[parseResult.mark & 3];
        boolean bl = this.def = (parseResult.mark & 4) == 0;
        if (this.mode == RetrieveMode.OFFLINE_PLAYER || this.mode == RetrieveMode.UUID) {
            this.offlinePlayerExpr = expressions[0];
            this.stringExpr = expressions[1];
        } else {
            this.stringExpr = expressions[0];
            this.offlinePlayerExpr = null;
        }
        this.timeoutExpr = expressions[expressions.length - 1];
        return true;
    }

    public static enum RetrieveMode {
        FILE,
        URL,
        OFFLINE_PLAYER,
        UUID;

    }
}

