/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldManagement;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.WorldCreator.Dimension;
import com.pie.tlatoani.WorldCreator.WorldCreatorData;
import com.pie.tlatoani.WorldManagement.WorldLoader.WorldLoader;
import java.util.Optional;
import org.bukkit.WorldType;
import org.bukkit.event.Event;

public class EffCreateWorld
extends Effect {
    private Expression<String> nameExpr;
    private Expression<Dimension> dimensionExpr;
    private Expression<String> seedExpr;
    private Expression<WorldType> typeExpr;
    private Expression<String> generatorExpr;
    private Expression<String> generatorSettingsExpr;
    private Expression<Boolean> structuresExpr;
    private boolean autoload;

    protected void execute(Event event) {
        String name = (String)this.nameExpr.getSingle(event);
        Logging.debug((Object)this, "World Creation Name: " + name);
        Dimension dimension = Optional.ofNullable(this.dimensionExpr).map(expr -> (Dimension)((Object)((Object)expr.getSingle(event)))).orElse(null);
        String seed = Optional.ofNullable(this.seedExpr).map(expr -> (String)expr.getSingle(event)).orElse(null);
        WorldType type = Optional.ofNullable(this.typeExpr).map(expr -> (WorldType)expr.getSingle(event)).orElse(null);
        String generator = Optional.ofNullable(this.generatorExpr).map(expr -> (String)expr.getSingle(event)).orElse(null);
        String generatorSettings = Optional.ofNullable(this.generatorSettingsExpr).map(expr -> (String)expr.getSingle(event)).orElse(null);
        Boolean structures = Optional.ofNullable(this.structuresExpr).map(expr -> (Boolean)expr.getSingle(event)).orElse(null);
        WorldCreatorData creator = WorldCreatorData.withGeneratorID(name, dimension, seed, type, generator, generatorSettings, structures);
        creator.createWorld();
        if (this.autoload) {
            WorldLoader.setCreator(creator);
        }
    }

    public String toString(Event event, boolean b) {
        return "create new world named " + this.nameExpr + (this.dimensionExpr != null || this.typeExpr != null || this.seedExpr != null || this.generatorExpr != null || this.generatorSettingsExpr != null || this.structuresExpr != null ? " with" + (this.dimensionExpr != null ? " dimension " + this.dimensionExpr : "") + (this.seedExpr != null ? " seed " + this.seedExpr : "") + (this.typeExpr != null ? " type " + this.typeExpr : "") + (this.generatorExpr != null ? " generator " + this.generatorExpr : "") + (this.generatorSettingsExpr != null ? " generator settings " + this.generatorSettingsExpr : "") + (this.structuresExpr != null ? " structures " + this.structuresExpr : "") : "");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.autoload = parseResult.mark == 1;
        this.nameExpr = expressions[0];
        this.dimensionExpr = expressions[1];
        this.seedExpr = expressions[2];
        this.typeExpr = expressions[3];
        this.generatorExpr = expressions[4];
        this.generatorSettingsExpr = expressions[5];
        this.structuresExpr = expressions[6];
        return true;
    }
}

