/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Core.Static.MathUtil;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.Invalidatable;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class Tab {
    public final Tablist tablist;
    public final String name;
    public final UUID uuid;
    protected Optional<String> displayName;
    protected Optional<Integer> latencyBars;
    protected Optional<Skin> icon;
    protected Invalidatable<Integer> score;

    public Tab(Tablist tablist, String name, UUID uuid) {
        this(tablist, name, uuid, null, null, null, null);
    }

    public Tab(Tablist tablist, String name, UUID uuid, @Nullable String displayName, @Nullable Integer latencyBars, @Nullable Skin icon, @Nullable Integer score) {
        if (tablist == null || name == null || uuid == null) {
            throw new NullPointerException("The tablist, name, and uuid parameters should all be non-null: tablist = " + tablist + ", name = " + name + ", uuid = " + uuid);
        }
        this.tablist = tablist;
        this.name = name;
        this.uuid = uuid;
        this.displayName = Optional.ofNullable(displayName);
        this.latencyBars = Optional.ofNullable(latencyBars);
        this.icon = Optional.ofNullable(icon);
        this.score = score == null ? Invalidatable.invalid() : tablist.createScore(score);
    }

    public PacketContainer playerInfoPacket(EnumWrappers.PlayerInfoAction action) {
        if (action == null) {
            throw new IllegalArgumentException("The action = " + action + " should not be null");
        }
        return PacketUtil.playerInfoPacket(this.displayName.orElse(""), this.latencyBars.orElse(5), null, this.name, this.uuid, this.icon.orElse(this.tablist.getDefaultIcon().orElse(Tablist.DEFAULT_SKIN_TEXTURE)), action);
    }

    public PacketContainer updateScorePacket() {
        return PacketUtil.scorePacket(this.name, "MundoSK_Tablist", this.getScore().orElse(0), EnumWrappers.ScoreboardAction.CHANGE);
    }

    public void refresh() {
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
    }

    public boolean isDefault() {
        return !this.displayName.isPresent() && !this.latencyBars.isPresent() && !this.icon.isPresent() && !this.getScore().isPresent();
    }

    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(@Nullable String displayName) {
        if (OptionalUtil.equal(displayName, this.displayName)) {
            return;
        }
        this.displayName = Optional.ofNullable(displayName);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME), this);
    }

    public Optional<Integer> getLatencyBars() {
        return this.latencyBars;
    }

    public void setLatencyBars(@Nullable Integer latencyBars) {
        if (latencyBars != null && !MathUtil.isInRange(0.0, latencyBars.intValue(), 5.0)) {
            throw new IllegalArgumentException("Illegal latencyBars value, should be within 0 and 5 inclusive, latency: " + latencyBars);
        }
        if (OptionalUtil.equal(latencyBars, this.latencyBars)) {
            return;
        }
        this.latencyBars = Optional.ofNullable(latencyBars);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.UPDATE_LATENCY), this);
    }

    public Optional<Skin> getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable Skin icon) {
        if (OptionalUtil.referencesEqual(icon, this.icon)) {
            return;
        }
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        this.icon = Optional.ofNullable(icon);
        this.tablist.sendPacket(this.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
    }

    public Optional<Integer> getScore() {
        return this.score.get();
    }

    public void setScore(@Nullable Integer score) {
        if (!this.tablist.areScoresEnabled() || OptionalUtil.equal(score, this.getScore())) {
            return;
        }
        this.score = score == null ? Invalidatable.invalid() : this.tablist.createScore(score);
        this.tablist.sendPacket(this.updateScorePacket(), this);
    }

    public void applyChanges(Tab otherTab) {
        if (otherTab == null) {
            throw new IllegalArgumentException("The otherTab = " + otherTab + " should not be null");
        }
        if (this.icon.isPresent() && !OptionalUtil.referencesEqual(this.icon.get(), otherTab.getIcon())) {
            this.displayName.ifPresent(val -> {
                otherTab.displayName = Optional.of(val);
            });
            this.latencyBars.ifPresent(val -> {
                otherTab.latencyBars = Optional.of(val);
            });
            otherTab.setIcon(this.icon.get());
        } else {
            this.displayName.ifPresent(otherTab::setDisplayName);
            this.latencyBars.ifPresent(otherTab::setLatencyBars);
        }
        this.getScore().ifPresent(otherTab::setScore);
    }
}

