/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Group.TablistProvider;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.Tablist;
import java.util.Optional;
import org.bukkit.event.Event;

public class EffCreateSimpleTab
extends Effect {
    private Expression<String> idExpression;
    private TablistProvider tablistProvider;
    private Expression<String> displayNameExpression;
    private Optional<Expression<Number>> latencyBarsExpression;
    private Optional<Expression<Skin>> iconExpression;
    private Optional<Expression<Number>> scoreExpression;

    protected void execute(Event event) {
        String id = (String)this.idExpression.getSingle(event);
        String displayName = (String)this.displayNameExpression.getSingle(event);
        if (id == null || displayName == null) {
            return;
        }
        if (id.length() > 12) {
            Skript.warning((String)("A script attempted to create a simple tab with the id \"" + id + "\", but simple tab ids can't be longer than 12 characters so no tab was created."));
            return;
        }
        Integer latencyBars = this.latencyBarsExpression.map(expression -> (Number)expression.getSingle(event)).map(Number::intValue).orElse(null);
        Skin icon = this.iconExpression.map(expression -> (Skin)expression.getSingle(event)).orElse(null);
        Integer score = this.scoreExpression.map(expression -> (Number)expression.getSingle(event)).map(Number::intValue).orElse(null);
        for (Tablist tablist : this.tablistProvider.get(event)) {
            if (!(tablist.getSupplementaryTablist() instanceof SimpleTablist)) continue;
            SimpleTablist simpleTablist = (SimpleTablist)tablist.getSupplementaryTablist();
            simpleTablist.createTab(id, displayName, latencyBars, icon, score);
        }
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString("create simple tab " + this.idExpression + " [for %] with display name " + this.displayNameExpression + this.latencyBarsExpression.map(expr -> " latency bars " + expr).orElse("") + this.iconExpression.map(expr -> " icon " + expr).orElse("") + this.scoreExpression.map(expr -> " score " + expr).orElse(""));
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.idExpression = expressions[0];
        this.tablistProvider = TablistProvider.of(expressions, 1);
        this.displayNameExpression = expressions[3];
        this.latencyBarsExpression = Optional.ofNullable(expressions[4]);
        this.iconExpression = Optional.ofNullable(expressions[5]);
        this.scoreExpression = Optional.ofNullable(expressions[6]);
        return true;
    }
}

