/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Core.Registration;

import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.util.Pair;
import ch.njol.yggdrasil.Fields;
import com.pie.tlatoani.Core.Registration.DocumentationElement;
import com.pie.tlatoani.Core.Registration.MundoClassInfo;
import com.pie.tlatoani.Core.Static.Logging;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EnumClassInfo<E>
extends MundoClassInfo<E> {
    private final List<Map.Entry<String, E>> pairings;
    private Object[] allValues = null;

    public EnumClassInfo(Class<E> c, String[] names, String category, E[] values) {
        super(c, names, category);
        this.pairings = new ArrayList<Map.Entry<String, E>>(values.length);
        for (E value : values) {
            this.pair(value.toString(), value);
        }
        Logging.debug((Object)this, "pie");
        this.afterInitialization();
    }

    public EnumClassInfo(Class<E> c, String[] names, String category, Map<String, E> valueMap) {
        super(c, names, category);
        this.pairings = new ArrayList<Map.Entry<String, Map.Entry<String, E>>>(valueMap.entrySet());
        Logging.debug((Object)this, "pie");
        this.afterInitialization();
    }

    private void afterInitialization() {
        Logging.debug((Object)this, "afterInit");
        this.parser(new Parser<E>(){

            public E parse(String s, ParseContext parseContext) {
                return EnumClassInfo.this.parse(s);
            }

            public String toString(E e, int i) {
                return EnumClassInfo.this.toString(e);
            }

            public String toVariableNameString(E e) {
                return EnumClassInfo.this.toString(e);
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        });
        this.serializer(new Serializer<E>(){

            public Fields serialize(E e) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putObject("value", (Object)EnumClassInfo.this.toString(e));
                return fields;
            }

            public void deserialize(E e, Fields fields) throws StreamCorruptedException, NotSerializableException {
                throw new UnsupportedOperationException();
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }

            public E deserialize(Fields fields) throws StreamCorruptedException {
                return EnumClassInfo.this.parse((String)fields.getObject("value"));
            }
        });
    }

    public EnumClassInfo<E> pair(String name, E value) {
        this.pairings.add(0, (Map.Entry<String, Pair>)new Pair((Object)name.toUpperCase(), value));
        return this;
    }

    @Override
    public DocumentationElement.Type build() {
        String[] usages = new String[this.pairings.size()];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = this.pairings.get(i).getKey().toLowerCase();
        }
        return new DocumentationElement.Type(this.name, this.category, this.syntaxes, usages, this.description, this.originVersion, this.requiredPlugins, this.examples);
    }

    @Override
    public EnumClassInfo<E> requiredPlugins(String ... requiredPlugins) {
        super.requiredPlugins(requiredPlugins);
        return this;
    }

    public String getPluralCodeName() {
        if (this.getCodeName().endsWith("y")) {
            return this.getCodeName().substring(0, this.getCodeName().length() - 1) + "ies";
        }
        return this.getCodeName() + "s";
    }

    public E parse(String s) {
        s = s.toUpperCase();
        for (Map.Entry<String, E> pairing : this.pairings) {
            if (!s.equals(pairing.getKey())) continue;
            return pairing.getValue();
        }
        return null;
    }

    public String toString(E e) {
        Logging.debug((Object)this, "tostringing: " + e);
        for (Map.Entry<String, E> pairing : this.pairings) {
            if (e != pairing.getValue()) continue;
            return pairing.getKey().toLowerCase();
        }
        return null;
    }

    public Object[] getAllValues() {
        if (this.allValues == null) {
            HashSet<E> allValuesSet = new HashSet<E>();
            for (Map.Entry<String, E> pairing : this.pairings) {
                allValuesSet.add(pairing.getValue());
            }
            this.allValues = allValuesSet.toArray();
        }
        return this.allValues;
    }
}

