/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Collections;

import com.pie.tlatoani.Util.Static.Logging;
import com.pie.tlatoani.Util.Static.OptionalUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;

public class TreeIterator
implements Iterator {
    private Base<String, Object> baseIterator;
    private TreeIterator subIterator = null;
    private String currentIndex;
    private String currentPrefix;
    private String nextIndex = null;
    private Object next = null;

    public TreeIterator(TreeMap<String, Object> treeMap) {
        this.baseIterator = new Base<String, Object>(treeMap);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            Logging.debug((Object)this, "Next was not null");
            Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
            return true;
        }
        if (this.subIterator != null) {
            if (this.subIterator.hasNext() && ((Base)this.baseIterator).treeMap.get(this.currentPrefix) == ((Base)this.subIterator.baseIterator).treeMap) {
                this.next = this.subIterator.next();
                this.nextIndex = this.currentPrefix + "::" + this.subIterator.currentIndex();
                Logging.debug((Object)this, "The sub iterator had another one!");
                Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
                return true;
            }
            this.subIterator = null;
            this.currentPrefix = null;
            Logging.debug((Object)this, "End of sub iterator");
        }
        if (this.baseIterator.hasNext()) {
            Object entry = this.baseIterator.next();
            if (entry.getValue() instanceof TreeMap) {
                this.currentPrefix = (String)entry.getKey();
                this.subIterator = new TreeIterator((TreeMap)entry.getValue());
                Logging.debug((Object)this, "Found a new sub iterator!");
                Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
                return this.hasNext();
            }
            this.nextIndex = (String)entry.getKey();
            this.next = entry.getValue();
            Logging.debug((Object)this, "Found a non-iterator value");
            Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
            return true;
        }
        return false;
    }

    public Object next() {
        if (this.hasNext()) {
            Object tempcurrent = this.next;
            this.currentIndex = this.nextIndex;
            this.next = null;
            this.nextIndex = null;
            return tempcurrent;
        }
        throw new NoSuchElementException("Called next() on a TreeIterator without a next element");
    }

    public String currentIndex() {
        Logging.debug((Object)this, "Current index: " + this.currentIndex);
        Logging.debug((Object)this, "Next index: " + this.nextIndex);
        return this.currentIndex;
    }

    public static class Base<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final TreeMap<K, V> treeMap;
        private Optional<K> key = Optional.empty();

        public Base(TreeMap<K, V> treeMap) {
            this.treeMap = treeMap;
        }

        @Override
        public boolean hasNext() {
            return this.key.isPresent() && !this.key.equals(this.treeMap.lastKey()) || !this.treeMap.isEmpty();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry nextEntry = OptionalUtil.map(this.key, this.treeMap::firstEntry, this.treeMap::higherEntry);
            this.key = Optional.of(nextEntry.getKey());
            return nextEntry;
        }
    }
}

