/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class UtilDataClassGeneration {
    public static final String TAB = "    ";

    public static String[] generateClassCode(String typeName, Property[] properties) {
        String className = "MundoSKDataClass" + typeName.toUpperCase();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("public class " + className + " {");
        for (Property property2 : properties) {
            lines.add("    public final " + property2.type.getName() + " " + property2.javaName + ";");
        }
        lines.add("");
        lines.add("    private " + className + "(" + Arrays.stream(properties).map(property -> property.type.getName() + " " + property.javaName).collect(Collectors.joining(", ")) + ") {");
        for (Property property2 : properties) {
            lines.add("        this." + property2.javaName + " = " + property2.javaName + ";");
        }
        lines.add("    }");
        lines.add("");
        lines.add("    public " + className + " create(" + Arrays.stream(properties).map(property -> property.type.getName() + " " + property.javaName).collect(Collectors.joining(", ")) + ") {");
        for (Property property2 : properties) {
            if (property2.nullable) continue;
            lines.add("        if (" + property2.javaName + " == null) return null;");
        }
        lines.add("        return new " + className + "(" + Arrays.stream(properties).map(property -> property.javaName).collect(Collectors.joining(", ")) + ");");
        lines.add("    }");
        for (Property property2 : properties) {
            lines.add("");
            lines.add("    public " + className + " set" + property2.javaName.toUpperCase() + "(" + property2.type.getName() + " " + property2.javaName + ") {");
            if (!property2.nullable) {
                lines.add("        if (" + property2.javaName + " == null) return null;");
            }
            lines.add("        return new " + className + "(" + Arrays.stream(properties).map(property1 -> property1.javaName).collect(Collectors.joining(", ")) + ");");
            lines.add("    }");
        }
        lines.add("}");
        return lines.toArray(new String[0]);
    }

    public static class Property {
        public final Class type;
        public final String name;
        public final String javaName;
        public final boolean nullable;

        public Property(Class type, String name, boolean nullable) {
            this.type = type;
            this.name = name;
            this.javaName = name.replace(' ', '_');
            this.nullable = nullable;
        }
    }
}

