/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.SkriptEventInfo;
import com.pie.tlatoani.Core.Static.Logging;
import com.pie.tlatoani.Core.Static.Reflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringJoiner;
import org.bukkit.event.Event;

public class TestEventConstruction {
    public static void test() {
        try {
            Collection skriptEvents = (Collection)Reflection.getStaticField(Skript.class, "events");
            HashSet<Class> successfulEventClasses = new HashSet<Class>();
            HashSet<Class> failedEventClasses = new HashSet<Class>();
            for (SkriptEventInfo skriptEventInfo : skriptEvents) {
                for (Class eventClass : skriptEventInfo.events) {
                    if (successfulEventClasses.contains(eventClass) || failedEventClasses.contains(eventClass)) continue;
                    if (TestEventConstruction.testEventClass(eventClass)) {
                        successfulEventClasses.add(eventClass);
                        continue;
                    }
                    failedEventClasses.add(eventClass);
                }
            }
            Logging.info("Out of " + (successfulEventClasses.size() + failedEventClasses.size()) + " event classes,");
            Logging.info(successfulEventClasses.size() + " succeeded and " + failedEventClasses.size() + " failed.");
            Logging.info("The failures were " + failedEventClasses);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logging.reportException(TestEventConstruction.class, e);
        }
    }

    private static boolean testEventClass(Class<? extends Event> eventClass) {
        for (Constructor<?> constructor : eventClass.getConstructors()) {
            try {
                Object[] parameters = new Object[constructor.getParameterCount()];
                Object creation = constructor.newInstance(parameters);
                StringJoiner logBuilder = new StringJoiner(", ", "Success, creation: " + creation + ", constructor: " + eventClass.getName() + "(", ")");
                for (Class<?> paramType : constructor.getParameterTypes()) {
                    logBuilder.add(paramType.getName());
                }
                Logging.info(logBuilder.toString());
                return true;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            }
        }
        Logging.info("Failure for class " + eventClass.getName());
        return false;
    }
}

