/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Collections;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;

public interface Streamable<T>
extends Iterable<T> {
    default public Stream<T> stream() {
        return Streams.stream((Iterable)this);
    }

    public static <T> Streamable<T> empty() {
        return Streamable.of(Collections.emptyList());
    }

    public static <T> Streamable<T> singleton(T element) {
        return Streamable.of(Collections.singleton(element));
    }

    public static <T> Streamable<T> of(T[] array) {
        return Streamable.of(Arrays.asList(array));
    }

    public static <T> Streamable<T> of(Collection<T> collection) {
        return new StreamableCollection(collection);
    }

    public static class StreamableCollection<T>
    implements Streamable<T> {
        private final Collection<T> collection;

        private StreamableCollection(Collection<T> collection) {
            this.collection = collection;
        }

        @Override
        public Iterator<T> iterator() {
            return this.collection.iterator();
        }

        @Override
        public Stream<T> stream() {
            return this.collection.stream();
        }
    }
}

