/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class GroupedList<E> {
    private List<E> list = new ArrayList();
    private Optional<Key> last = Optional.empty();

    public E get(int index) {
        return this.list.get(index);
    }

    public Stream<E> stream() {
        return this.list.stream();
    }

    public void clear() {
        this.last = Optional.empty();
        this.list.clear();
    }

    public Key addGroup(Collection<E> elems) {
        return new Key(elems);
    }

    public void removeGroup(Key key) {
        key.remove();
    }

    public class Key {
        public final int amount;
        private int start;
        private Optional<Key> prev;
        private Optional<Key> next = Optional.empty();

        private Key(Collection<E> elems) {
            this.amount = elems.size();
            GroupedList.this.list.addAll(elems);
            this.prev = GroupedList.this.last;
            GroupedList.this.last = Optional.of(this);
            this.start = this.prev.map(key -> key.start + key.amount).orElse(0);
            this.prev.ifPresent(key -> {
                key.next = Optional.of(this);
            });
        }

        private void remove() {
            for (int i = 0; i < this.amount; ++i) {
                GroupedList.this.list.remove(this.start);
            }
            Key key2 = this.next.orElse(null);
            while (key2 != null) {
                key2.start -= this.amount;
                key2 = key2.next.orElse(null);
            }
            this.prev.ifPresent(key -> {
                key.next = this.next;
            });
            this.next.ifPresent(key -> {
                key.prev = this.prev;
            });
            if (!this.next.isPresent()) {
                GroupedList.this.last = this.prev;
            }
        }
    }
}

