/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Group;

import ch.njol.skript.lang.Expression;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.Core.Static.Utilities;
import com.pie.tlatoani.Tablist.Group.TablistGroup;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Tablist.TablistManager;
import com.pie.tlatoani.Util.Collections.Streamable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class TablistProvider {
    public abstract Stream<Tablist> view(Event var1);

    public abstract Streamable<Tablist> get(Event var1);

    public abstract boolean check(Event var1, Function<Tablist, Boolean> var2, boolean var3);

    public abstract boolean isSingle();

    public abstract String toString();

    public static TablistProvider of(Expression<?>[] expressions, int playerExpressionIndex) {
        if (expressions.length > playerExpressionIndex && expressions[playerExpressionIndex] != null) {
            return new Players(expressions[playerExpressionIndex]);
        }
        if (expressions.length > playerExpressionIndex + 1 && expressions[playerExpressionIndex + 1] != null) {
            return new Group(expressions[playerExpressionIndex + 1]);
        }
        return new Group();
    }

    private static class Group
    extends TablistProvider {
        private final Optional<Expression<String>> expression;

        private Group() {
            this.expression = Optional.empty();
        }

        private Group(Expression<String> expression) {
            this.expression = Optional.of(expression);
        }

        @Override
        public Stream<Tablist> view(Event event) {
            return OptionalUtil.stream(this.getGroup(event).map(TablistGroup::getDummy));
        }

        @Override
        public Streamable<Tablist> get(Event event) {
            return this.getGroup(event).map(Function.identity()).orElse(Streamable.empty());
        }

        public Optional<TablistGroup> getGroup(Event event) {
            return this.expression.map(expr -> Optional.ofNullable(expr.getSingle(event)).map(TablistManager::getTablistGroup)).orElse(Optional.of(TablistManager.GLOBAL_GROUP));
        }

        @Override
        public String toString() {
            return this.expression.map(expr -> "group" + expr).orElse("global group");
        }

        @Override
        public boolean check(Event event, Function<Tablist, Boolean> condition, boolean positive) {
            return this.getGroup(event).map(group -> positive == (Boolean)condition.apply(group.getDummy())).orElse(false);
        }

        @Override
        public boolean isSingle() {
            return true;
        }
    }

    private static class TablistOfPlayerIterator
    implements Iterator<Tablist> {
        private final Iterator<? extends Player> playerIterator;
        private Player next = null;

        private TablistOfPlayerIterator(Iterator<? extends Player> playerIterator) {
            this.playerIterator = playerIterator;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.playerIterator.hasNext()) {
                this.next = this.playerIterator.next();
                if (this.next.isOnline()) continue;
                this.next = null;
            }
            return this.next != null;
        }

        @Override
        public Tablist next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tablist result = TablistManager.getTablistOfPlayer(this.next);
            this.next = null;
            return result;
        }
    }

    private static class Players
    extends TablistProvider {
        private final Expression<Player> expression;

        private Players(Expression<Player> expression) {
            this.expression = expression;
        }

        @Override
        public Stream<Tablist> view(Event event) {
            return this.get(event).stream();
        }

        @Override
        public Streamable<Tablist> get(Event event) {
            return () -> new TablistOfPlayerIterator(this.expression.iterator(event));
        }

        @Override
        public String toString() {
            return this.expression.toString();
        }

        @Override
        public boolean check(Event event, Function<Tablist, Boolean> condition, boolean positive) {
            return Utilities.check(this.expression, event, player -> player.isOnline() && (Boolean)condition.apply(TablistManager.getTablistOfPlayer(player)) != false, positive);
        }

        @Override
        public boolean isSingle() {
            return this.expression.isSingle();
        }
    }
}

