/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Player;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Core.Static.Config;
import com.pie.tlatoani.Core.Static.OptionalUtil;
import com.pie.tlatoani.Core.Static.Scheduling;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerTablist {
    public final Tablist tablist;
    private Optional<Map<Player, Optional<Tab>>> tabs = Optional.of(new HashMap());

    public PlayerTablist(Tablist tablist) {
        this.tablist = tablist;
    }

    public Optional<Tab> getTabIfModified(Player player) {
        return this.tabs.flatMap(map -> Optional.ofNullable(map.computeIfPresent(player, (__, tabOptional) -> {
            if (tabOptional.isPresent() && ((Tab)tabOptional.get()).isDefault()) {
                return null;
            }
            return tabOptional;
        })).orElse(Optional.empty()));
    }

    public Optional<Tab> getTab(Player player) {
        return this.tabs.flatMap(map -> map.computeIfAbsent(player, __ -> Optional.of(new PlayerTab(player))));
    }

    public boolean isPlayerVisible(Player player) {
        return this.tabs.map(map -> Optional.ofNullable(map.get(player)).map(Optional::isPresent).orElse(true)).orElse(false);
    }

    public void showPlayer(Player player) {
        if (!this.tabs.isPresent()) {
            this.tabs = Optional.of(new HashMap());
            this.tabs.ifPresent(map -> {
                for (Player player1 : Bukkit.getOnlinePlayers()) {
                    map.put(player1, Optional.empty());
                }
            });
        }
        this.tabs.ifPresent(map -> map.computeIfPresent(player, (__, tabOptional) -> {
            if (!tabOptional.isPresent()) {
                this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), PlayerTablist.class);
                return null;
            }
            return tabOptional;
        }));
    }

    public void hidePlayer(Player player) {
        this.tabs.ifPresent(map -> map.compute(player, (__, tabOptional) -> {
            if (tabOptional == null || tabOptional.isPresent()) {
                this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
            }
            return Optional.empty();
        }));
    }

    public boolean arePlayersVisible() {
        return this.tabs.isPresent();
    }

    public void showAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.showPlayer(player);
        }
    }

    public void hideAllPlayers() {
        this.tabs.ifPresent(map -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Optional playerTabOptional = (Optional)map.get(player);
                if (playerTabOptional != null && !playerTabOptional.isPresent()) continue;
                this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
            }
            this.tabs = Optional.empty();
        });
    }

    public void clearModifications() {
        OptionalUtil.consume(this.tabs, this::showAllPlayers, map -> {
            map.forEach((player, tabOptional) -> OptionalUtil.consume(tabOptional, () -> this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), this), tab -> {
                tab.setDisplayName(null);
                tab.setLatencyBars(null);
                tab.setScore(null);
            }));
            map.clear();
        });
    }

    public void onJoin(Player player) {
        if (!this.tabs.isPresent()) {
            Scheduling.syncDelay(Config.TABLIST_SPAWN_REMOVE_TAB_DELAY.getCurrentValue(), () -> this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this));
        }
    }

    public void onQuit(Player player) {
        this.tabs.ifPresent(map -> {
            Optional cfr_ignored_0 = (Optional)map.remove(player);
        });
    }

    public void applyChanges(PlayerTablist playerTablist) {
        OptionalUtil.consume(this.tabs, playerTablist::hideAllPlayers, tabMap -> tabMap.forEach((player, tabOptional) -> OptionalUtil.consume(tabOptional, () -> playerTablist.hidePlayer((Player)player), tab -> {
            playerTablist.showPlayer((Player)player);
            tab.applyChanges(playerTablist.getTab((Player)player).get());
        })));
    }

    public class PlayerTab
    extends Tab {
        private final Player objPlayer;

        private PlayerTab(Player player) {
            super(PlayerTablist.this.tablist, player.getName(), player.getUniqueId());
            if (!player.isOnline()) {
                throw new IllegalArgumentException("The player parameter in the constructor of PlayerTab must be online: " + player);
            }
            this.objPlayer = player;
        }

        @Override
        public PacketContainer playerInfoPacket(EnumWrappers.PlayerInfoAction action) {
            return PacketUtil.playerInfoPacket(this.objPlayer, action);
        }

        @Override
        public void setIcon(Skin value) {
            throw new UnsupportedOperationException("You can't set the icon of a PlayerTab!");
        }
    }
}

