/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.collect.ImmutableList;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import com.pie.tlatoani.Util.Invalidatable;
import com.pie.tlatoani.Util.Static.OptionalUtil;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import mundosk_libraries.packetwrapper.WrapperPlayServerPlayerListHeaderFooter;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardDisplayObjective;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardObjective;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Tablist {
    private final Optional<Player> target;
    private boolean scoresEnabled;
    private final Invalidatable.Creator scoreCreator = new Invalidatable.Creator();
    private ImmutableList<String> header = ImmutableList.of();
    private ImmutableList<String> footer = ImmutableList.of();
    private Optional<Skin> defaultIcon = Optional.empty();
    private final PlayerTablist playerTablist = new PlayerTablist(this);
    private SupplementaryTablist supplementaryTablist = new SimpleTablist(this.playerTablist);
    public static final Skin DEFAULT_SKIN_TEXTURE = Skin.ALL_WHITE;
    public static final String OBJECTIVE_NAME = "MundoSK_Tablist";

    public Tablist() {
        this.target = Optional.empty();
    }

    Tablist(Player target) {
        this.target = Optional.of(target);
    }

    public Optional<PlayerTablist> getPlayerTablist() {
        if (this.supplementaryTablist.allowExternalPlayerTabModification()) {
            return Optional.of(this.playerTablist);
        }
        return Optional.empty();
    }

    void onJoin(Player player) {
        this.playerTablist.onJoin(player);
    }

    void onQuit(Player player) {
        this.playerTablist.onQuit(player);
    }

    PlayerInfoData onPlayerInfoPacket(PlayerInfoData oldPlayerInfoData, Player objPlayer) {
        if (!this.target.isPresent()) {
            throw new UnsupportedOperationException("This Tablist does not have a target!");
        }
        Player target = this.target.get();
        return this.playerTablist.getTabIfModified(objPlayer).map(tab -> {
            WrappedChatComponent displayName = tab.getDisplayName().map(rawDisplayName -> Optional.ofNullable(target.getScoreboard()).map(scoreboard -> scoreboard.getEntryTeam(objPlayer.getName())).map(team -> team.getPrefix() + rawDisplayName + team.getSuffix()).orElse((String)rawDisplayName)).map(WrappedChatComponent::fromText).orElse(oldPlayerInfoData.getDisplayName());
            return new PlayerInfoData(oldPlayerInfoData.getProfile(), tab.getLatencyBars().map(PacketUtil::getPossibleLatency).orElse(oldPlayerInfoData.getLatency()).intValue(), oldPlayerInfoData.getGameMode(), displayName);
        }).orElse(oldPlayerInfoData);
    }

    public boolean arePlayersVisible() {
        return this.playerTablist.arePlayersVisible();
    }

    public boolean isPlayerVisible(Player player) {
        return this.playerTablist.isPlayerVisible(player);
    }

    public SupplementaryTablist getSupplementaryTablist() {
        return this.supplementaryTablist;
    }

    public void setSupplementaryTablist(Function<PlayerTablist, ? extends SupplementaryTablist> supplementaryTablistProvider) {
        this.supplementaryTablist.disable();
        this.supplementaryTablist = null;
        this.supplementaryTablist = supplementaryTablistProvider.apply(this.playerTablist);
    }

    public Optional<Skin> getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(@Nullable Skin icon) {
        if (!OptionalUtil.referencesEqual(icon, this.defaultIcon)) {
            this.defaultIcon = Optional.ofNullable(icon);
            if (this.supplementaryTablist != null) {
                this.supplementaryTablist.refreshIconsIfDefault();
            }
        }
    }

    public boolean areScoresEnabled() {
        return this.scoresEnabled;
    }

    public void setScoresEnabled(boolean enabled) {
        if (enabled) {
            this.enableScores();
        } else {
            this.disableScores();
        }
    }

    public void enableScores() {
        if (!this.areScoresEnabled()) {
            this.scoresEnabled = true;
            WrapperPlayServerScoreboardObjective createPacket = new WrapperPlayServerScoreboardObjective();
            createPacket.setName(OBJECTIVE_NAME);
            createPacket.setDisplayName(OBJECTIVE_NAME);
            createPacket.setMode(0);
            createPacket.setHealthDisplay(WrapperPlayServerScoreboardObjective.HealthDisplay.INTEGER);
            this.sendPacket(createPacket.getHandle(), this);
            WrapperPlayServerScoreboardDisplayObjective displayPacket = new WrapperPlayServerScoreboardDisplayObjective();
            displayPacket.setPosition(0);
            displayPacket.setScoreName(OBJECTIVE_NAME);
            this.sendPacket(displayPacket.getHandle(), this);
        }
    }

    public void disableScores() {
        if (this.areScoresEnabled()) {
            this.scoresEnabled = false;
            WrapperPlayServerScoreboardObjective removePacket = new WrapperPlayServerScoreboardObjective();
            removePacket.setName(OBJECTIVE_NAME);
            removePacket.setDisplayName(OBJECTIVE_NAME);
            removePacket.setMode(1);
            removePacket.setHealthDisplay(WrapperPlayServerScoreboardObjective.HealthDisplay.INTEGER);
            this.sendPacket(removePacket.getHandle(), this);
        }
    }

    Invalidatable<Integer> createScore(int score) {
        if (this.scoresEnabled) {
            return this.scoreCreator.create(score);
        }
        return Invalidatable.invalid();
    }

    public ImmutableList<String> getHeader() {
        return this.header;
    }

    public ImmutableList<String> getFooter() {
        return this.footer;
    }

    public void setHeader(ImmutableList<String> header) {
        this.setHeaderAndFooter(header, this.footer);
    }

    public void setFooter(ImmutableList<String> footer) {
        this.setHeaderAndFooter(this.header, footer);
    }

    public void setHeaderAndFooter(ImmutableList<String> header, ImmutableList<String> footer) {
        this.header = header;
        this.footer = footer;
        WrapperPlayServerPlayerListHeaderFooter packet = new WrapperPlayServerPlayerListHeaderFooter();
        packet.setHeader(PacketUtil.stringsToChatComponent(header));
        packet.setFooter(PacketUtil.stringsToChatComponent(footer));
        this.sendPacket(packet.getHandle(), this);
    }

    public void sendPacket(PacketContainer packet, Object exceptLoc) {
        this.target.filter(OfflinePlayer::isOnline).ifPresent(player -> PacketManager.sendPacket(packet, exceptLoc, player));
    }

    public void applyChanges(Tablist tablist) {
        if (this.areScoresEnabled()) {
            tablist.enableScores();
        }
        if (this.getSupplementaryTablist() instanceof SimpleTablist && ((SimpleTablist)this.getSupplementaryTablist()).isEmpty()) {
            this.playerTablist.applyChanges(tablist.playerTablist);
            this.defaultIcon.ifPresent(tablist::setDefaultIcon);
        } else if (tablist.getSupplementaryTablist().getClass() == this.supplementaryTablist.getClass()) {
            this.playerTablist.applyChanges(tablist.playerTablist);
            this.defaultIcon.ifPresent(tablist::setDefaultIcon);
            this.supplementaryTablist.applyChanges(tablist.getSupplementaryTablist());
        } else {
            tablist.setSupplementaryTablist(otherPlayerTablist -> {
                this.playerTablist.applyChanges((PlayerTablist)otherPlayerTablist);
                this.defaultIcon.ifPresent(tablist::setDefaultIcon);
                return this.supplementaryTablist.basicClone((PlayerTablist)otherPlayerTablist);
            });
            this.supplementaryTablist.applyChanges(tablist.getSupplementaryTablist());
        }
        ImmutableList<String> oldHeader = tablist.getHeader();
        ImmutableList.Builder headerBuilder = ImmutableList.builder();
        for (int i = 0; i < Math.max(oldHeader.size(), this.header.size()); ++i) {
            if (i < this.header.size() && !((String)this.header.get(i)).isEmpty()) {
                headerBuilder.add(this.header.get(i));
                continue;
            }
            if (i < oldHeader.size()) {
                headerBuilder.add(oldHeader.get(i));
                continue;
            }
            headerBuilder.add((Object)"");
        }
        ImmutableList<String> oldFooter = tablist.getHeader();
        ImmutableList.Builder footerBuilder = ImmutableList.builder();
        for (int i = 0; i < Math.max(oldFooter.size(), this.footer.size()); ++i) {
            if (i < this.footer.size() && !((String)this.footer.get(i)).isEmpty()) {
                footerBuilder.add(this.footer.get(i));
                continue;
            }
            if (i < oldFooter.size()) {
                footerBuilder.add(oldFooter.get(i));
                continue;
            }
            footerBuilder.add((Object)"");
        }
        tablist.setHeaderAndFooter((ImmutableList<String>)headerBuilder.build(), (ImmutableList<String>)footerBuilder.build());
    }

    public String toString() {
        return this.target.map(player -> "Tablist(" + player.getName() + ")").orElse(super.toString());
    }
}

