/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WebSocket;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.pie.tlatoani.Util.Skript.MundoEventScope;
import com.pie.tlatoani.Util.Skript.ScopeUtil;
import com.pie.tlatoani.Util.Static.Logging;
import com.pie.tlatoani.WebSocket.WebSocketClientFunctionality;
import com.pie.tlatoani.WebSocket.WebSocketManager;
import java.util.Optional;
import org.bukkit.event.Event;

public class ScopeWebSocketClient
extends MundoEventScope {
    private WebSocketClientFunctionality clientFunctionality;
    private WebSocketClientFunctionality.Nebula nebula;

    @Override
    public void afterInit() {
        this.clientFunctionality.load(this.nebula);
        Logging.debug((Object)this, "registered: " + this.clientFunctionality);
    }

    public void unregister(Trigger trigger) {
        this.clientFunctionality.unload();
        Logging.debug((Object)this, "unregistered");
    }

    public void unregisterAll() {
        WebSocketManager.clearClientFunctionalities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        this.clientFunctionality = WebSocketManager.getClientFunctionality((String)literals[0].getSingle());
        this.nebula = new WebSocketClientFunctionality.Nebula();
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        Logging.debug((Object)this, "init()ing");
        try {
            if (this.clientFunctionality.isLoaded()) {
                Skript.warning((String)("You seem to have two 'websocket client' instances with the id \"" + this.clientFunctionality.id + "\" in your code. If you do, note that only one of them will be used. If you don't, you can ignore this warning."));
                this.clientFunctionality.unload();
            }
            for (Node node : topNode) {
                SkriptLogger.setNode((Node)node);
                Logging.debug((Object)this, "Current node: " + node.getKey());
                if (!(node instanceof SectionNode)) {
                    Skript.error((String)"'websocket client' should only have sections directly under it!");
                    boolean bl = false;
                    return bl;
                }
                SectionNode subNode = (SectionNode)node;
                if (subNode.getKey().equals("on open")) {
                    if (this.nebula.onOpen.isPresent()) {
                        Skript.error((String)"You cannot have two 'on open' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onOpen = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on handshake")) {
                    if (this.nebula.onHandshake.isPresent()) {
                        Skript.error((String)"You cannot have two 'on handshake' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onHandshake = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on close")) {
                    if (this.nebula.onClose.isPresent()) {
                        Skript.error((String)"You cannot have two 'on close' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onClose = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on message")) {
                    if (this.nebula.onMessage.isPresent()) {
                        Skript.error((String)"You cannot have two 'on message' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onMessage = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on error")) {
                    if (this.nebula.onError.isPresent()) {
                        Skript.error((String)"You cannot have two 'on error' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onError = Optional.of(subNode);
                    continue;
                }
                Skript.error((String)"The only sections allowed under 'websocket client' are 'on open', 'on close', 'on message', and 'on error'!");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ScopeUtil.removeSubNodes(topNode);
        }
    }

    public String toString(Event event, boolean b) {
        return "websocket client \"" + this.clientFunctionality.id + "\"";
    }
}

