/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Collections;

import com.google.common.collect.ImmutableList;
import com.pie.tlatoani.Util.Static.Logging;
import com.pie.tlatoani.Util.Static.MundoUtil;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ImmutableGroupedList<E, G>
extends AbstractList<E> {
    private final ImmutableList<E> list;
    private final ImmutableList<GroupIdentifier<G>> groupIDs;
    public final Comparator<G> keyComparator;

    private ImmutableGroupedList(ImmutableList<E> list, ImmutableList<GroupIdentifier<G>> groupIDs, Comparator<G> keyComparator) {
        this.list = list;
        this.groupIDs = groupIDs;
        this.keyComparator = keyComparator;
    }

    @Override
    public E get(int index) {
        return (E)this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public List<E> getGroup(G g) {
        return MundoUtil.binarySearchList(this.groupIDs, g, (gVal, id) -> this.keyComparator.compare(gVal, id.key)).map(x$0 -> new Group(x$0)).orElse(null);
    }

    public List<List<E>> getAllGroups() {
        return new GroupList();
    }

    public List<G> getGroupKeys() {
        return new GroupKeyList();
    }

    public static class OrderedBuilder<E, G> {
        public final Comparator<E> elemComparator;
        public final Comparator<G> keyComparator;
        private final TreeMap<G, Set<E>> setMap;

        public OrderedBuilder(Comparator<E> elemComparator, Comparator<G> keyComparator) {
            this.elemComparator = elemComparator;
            this.keyComparator = keyComparator;
            this.setMap = new TreeMap(keyComparator);
        }

        public void add(G key, E elem) {
            Set set = this.setMap.computeIfAbsent(key, __ -> new TreeSet<E>(this.elemComparator));
            set.add(elem);
        }

        public ImmutableGroupedList<E, G> build() {
            Logging.debug((Object)this, "Building an ImmutableGroupedList");
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            ImmutableList.Builder groupIDsBuilder = ImmutableList.builder();
            int prevElems = 0;
            for (Map.Entry<G, Set<E>> entry : this.setMap.entrySet()) {
                Logging.debug((Object)this, "Adding an entry: " + entry);
                listBuilder.addAll((Iterable)entry.getValue());
                groupIDsBuilder.add(new GroupIdentifier<G>(entry.getKey(), prevElems, prevElems += entry.getValue().size()));
            }
            return new ImmutableGroupedList(listBuilder.build(), groupIDsBuilder.build(), this.keyComparator);
        }
    }

    private class GroupKeyList
    extends AbstractList<G> {
        private GroupKeyList() {
        }

        @Override
        public G get(int index) {
            return ((GroupIdentifier)((ImmutableGroupedList)ImmutableGroupedList.this).groupIDs.get((int)index)).key;
        }

        @Override
        public int size() {
            return ImmutableGroupedList.this.groupIDs.size();
        }
    }

    private class GroupList
    extends AbstractList<List<E>> {
        private GroupList() {
        }

        @Override
        public List<E> get(int index) {
            return new Group((GroupIdentifier)ImmutableGroupedList.this.groupIDs.get(index));
        }

        @Override
        public int size() {
            return ImmutableGroupedList.this.groupIDs.size();
        }
    }

    private class Group
    extends AbstractList<E> {
        private final GroupIdentifier<G> identifier;

        Group(GroupIdentifier<G> identifier) {
            this.identifier = identifier;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return ImmutableGroupedList.this.list.get(index + this.identifier.start);
        }

        @Override
        public int size() {
            return this.identifier.end - this.identifier.start;
        }
    }

    private static class GroupIdentifier<G> {
        public final G key;
        public final int start;
        public final int end;

        GroupIdentifier(G key, int start, int end) {
            this.key = key;
            this.start = start;
            this.end = end;
        }
    }
}

