/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.Static.OptionalUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class SimpleTablist
implements SupplementaryTablist<SimpleTablist> {
    public final Tablist tablist;
    private final PlayerTablist playerTablist;
    private final HashMap<String, Tab> tabs = new HashMap();
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public SimpleTablist(PlayerTablist playerTablist) {
        this.tablist = playerTablist.tablist;
        this.playerTablist = playerTablist;
    }

    public void clear() {
        for (Tab tab : this.tabs.values()) {
            this.tablist.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        }
        this.tabs.clear();
    }

    public Tab createTab(String id, @Nullable String displayName, @Nullable Integer latencyBars, @Nullable Skin icon, @Nullable Integer score) {
        if (id == null || id.length() > 12) {
            throw new IllegalArgumentException("Invalid id = " + id);
        }
        return this.tabs.compute(id, (__, oldTab) -> {
            if (oldTab != null) {
                this.tablist.sendPacket(oldTab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
            }
            Tab newTab = new Tab(this.tablist, id + "-MSK", UUID.nameUUIDFromBytes(("MundoSKTablist::" + id).getBytes(UTF_8)), displayName, latencyBars, icon, score);
            this.tablist.sendPacket(newTab.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
            return newTab;
        });
    }

    public Optional<Tab> getTab(String id) {
        return Optional.ofNullable(this.tabs.get(id));
    }

    public void deleteTab(String id) {
        Tab tab = this.tabs.remove(id);
        if (tab != null) {
            this.tablist.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
        }
    }

    public boolean isEmpty() {
        return this.tabs.isEmpty();
    }

    @Override
    public void disable() {
        this.clear();
    }

    @Override
    public boolean allowExternalPlayerTabModification() {
        return true;
    }

    @Override
    public SimpleTablist basicClone(PlayerTablist otherPlayerTablist) {
        return new SimpleTablist(otherPlayerTablist);
    }

    @Override
    public void applyChanges(SimpleTablist simpleTablist) {
        this.tabs.forEach((id, tab) -> OptionalUtil.consume(simpleTablist.getTab((String)id), () -> simpleTablist.createTab((String)id, tab.getDisplayName().orElse(null), tab.getLatencyBars().orElse(null), tab.getIcon().orElse(null), tab.getScore().orElse(null)), tab::applyChanges));
    }

    @Override
    public void refreshIconsIfDefault() {
        for (Tab tab : this.tabs.values()) {
            if (tab.getIcon().isPresent()) continue;
            tab.refresh();
        }
    }
}

