/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldBorder;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.pie.tlatoani.Util.Static.Config;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;

public class EffChangeBorderDiameter
extends Effect {
    private Expression<World> worldExpression;
    private Expression<Number> numberExpression;
    private Expression<Timespan> timespanExpression;
    private Changer.ChangeMode changeMode;

    protected void execute(Event event) {
        World world = (World)this.worldExpression.getSingle(event);
        WorldBorder border = world.getWorldBorder();
        double value = ((Number)this.numberExpression.getSingle(event)).doubleValue();
        long seconds = ((Timespan)this.timespanExpression.getSingle(event)).getMilliSeconds() / 1000L;
        switch (this.changeMode) {
            case SET: {
                border.setSize(value, seconds);
                break;
            }
            case ADD: {
                border.setSize(border.getSize() + value, seconds);
                break;
            }
            case REMOVE: {
                border.setSize(border.getSize() - value, seconds);
            }
        }
    }

    public String toString(Event event, boolean b) {
        switch (this.changeMode) {
            case SET: {
                return "set diameter of " + this.worldExpression + " to " + this.numberExpression + " over " + this.timespanExpression;
            }
            case ADD: {
                return "add " + this.numberExpression + " to diameter of " + this.worldExpression + " over " + this.timespanExpression;
            }
            case REMOVE: {
                return "subtract " + this.numberExpression + " from diameter of " + this.worldExpression + " over " + this.timespanExpression;
            }
        }
        throw new IllegalStateException("Illegal ChangeMode: " + this.changeMode);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if ((parseResult.mark & 8) == 8) {
            if (Config.DISABLE_SIZE_SYNTAX.getCurrentValue().booleanValue()) {
                return false;
            }
            Skript.warning((String)"The 'size' alias for border diameter will be removed in a future version. Please use 'diameter' instead.");
        }
        this.worldExpression = EffChangeBorderDiameter.getWorldExpr(i, expressions);
        this.numberExpression = EffChangeBorderDiameter.getNumberExpr(i, expressions);
        this.timespanExpression = EffChangeBorderDiameter.getTimeExpr(i, expressions);
        this.changeMode = EffChangeBorderDiameter.getChangeMode(i);
        return true;
    }

    public static Expression<World> getWorldExpr(int i, Expression<?>[] expressions) {
        if (i < 4) {
            return expressions[0];
        }
        return expressions[1];
    }

    public static Expression<Number> getNumberExpr(int i, Expression<?>[] expressions) {
        if (i < 2) {
            return expressions[1];
        }
        if (i < 4) {
            return expressions[2];
        }
        return expressions[0];
    }

    public static Expression<Timespan> getTimeExpr(int i, Expression<?>[] expressions) {
        if (i == 2 || i == 3) {
            return expressions[1];
        }
        return expressions[2];
    }

    public static Changer.ChangeMode getChangeMode(int i) {
        if (i < 4) {
            return Changer.ChangeMode.SET;
        }
        if (i < 6) {
            return Changer.ChangeMode.ADD;
        }
        return Changer.ChangeMode.REMOVE;
    }
}

