/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Tablist.Group.TablistGroup;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.Static.Config;
import com.pie.tlatoani.Util.Static.Scheduling;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mundosk_libraries.packetwrapper.WrapperPlayServerNamedEntitySpawn;
import mundosk_libraries.packetwrapper.WrapperPlayServerPlayerInfo;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class TablistManager {
    private static final Map<Player, Tablist> tablistMap = new HashMap<Player, Tablist>();
    private static final Map<String, TablistGroup> tablistGroupMap = new HashMap<String, TablistGroup>();
    private static final ArrayList<Player> playersRespawning = new ArrayList();
    public static final TablistGroup GLOBAL_GROUP = new TablistGroup();

    public static Tablist getTablistOfPlayer(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("The player parameter in getTablistOfPlayer(Player player) must be non-null and online, player: " + player);
        }
        return tablistMap.computeIfAbsent(player, Tablist::new);
    }

    public static TablistGroup getTablistGroup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name parameter in getTablistGroup(Player player) must be non-null, name: " + name);
        }
        return tablistGroupMap.computeIfAbsent(name, __ -> new TablistGroup());
    }

    public static boolean deleteTablistGroup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name parameter in getTablistGroup(Player player) must be non-null, name: " + name);
        }
        TablistGroup group = tablistGroupMap.remove(name);
        if (group != null) {
            group.reset();
        }
        return group != null;
    }

    static void load() {
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(PlayerJoinEvent event) {
                TablistManager.onJoin(event.getPlayer());
            }
        }, (Plugin)Mundo.get());
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onQuit(PlayerQuitEvent event) {
                TablistManager.onQuit(event.getPlayer());
            }
        }, (Plugin)Mundo.get());
        TablistManager.loadPacketEventListeners();
    }

    private static void onJoin(Player player) {
        tablistMap.forEach((__, tablist) -> tablist.onJoin(player));
        Scheduling.syncDelay(Config.TABLIST_ADD_TO_DEFAULT_GROUP_DELAY.getCurrentValue(), () -> GLOBAL_GROUP.add(player));
    }

    private static void onQuit(Player player) {
        tablistMap.remove(player);
        tablistMap.forEach((__, tablist) -> tablist.onQuit(player));
        GLOBAL_GROUP.remove(player);
        tablistGroupMap.forEach((__, group) -> group.remove(player));
    }

    private static void loadPacketEventListeners() {
        PacketManager.onPacketEvent(PacketType.Play.Server.PLAYER_INFO, event -> {
            Player player = event.getPlayer();
            if (event.isCancelled() || player == null) {
                return;
            }
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(event.getPacket());
            Tablist tablist = TablistManager.getTablistOfPlayer(player);
            List<PlayerInfoData> oldData = packet.getData();
            ArrayList<PlayerInfoData> newData = new ArrayList<PlayerInfoData>(oldData.size());
            for (PlayerInfoData oldPlayerInfoData : oldData) {
                Player objPlayer = Bukkit.getPlayer((UUID)oldPlayerInfoData.getProfile().getUUID());
                if (objPlayer == null) {
                    newData.add(oldPlayerInfoData);
                    continue;
                }
                newData.add(tablist.onPlayerInfoPacket(oldPlayerInfoData, objPlayer));
            }
            packet.setData(newData);
        });
        PacketManager.onPacketEvent(PacketType.Play.Server.NAMED_ENTITY_SPAWN, event -> {
            Player player = event.getPlayer();
            WrapperPlayServerNamedEntitySpawn packet = new WrapperPlayServerNamedEntitySpawn(event.getPacket());
            Player objPlayer = Bukkit.getPlayer((UUID)packet.getPlayerUUID());
            if (event.isCancelled() || player == null || objPlayer == null) {
                return;
            }
            boolean tabVisible = TablistManager.getTablistOfPlayer(player).isPlayerVisible(objPlayer);
            if (!tabVisible) {
                PacketManager.sendPacket(PacketUtil.playerInfoPacket(objPlayer, EnumWrappers.PlayerInfoAction.ADD_PLAYER), TablistManager.class, player);
                Scheduling.syncDelay(Config.TABLIST_SPAWN_REMOVE_TAB_DELAY.getCurrentValue(), () -> PacketManager.sendPacket(PacketUtil.playerInfoPacket(objPlayer, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), TablistManager.class, player));
            }
        });
        PacketManager.onPacketEvent(PacketType.Play.Server.RESPAWN, event -> {
            Player player = event.getPlayer();
            if (event.isCancelled() || player == null || playersRespawning.contains(player)) {
                return;
            }
            boolean tabVisible = TablistManager.getTablistOfPlayer(player).isPlayerVisible(player);
            if (!tabVisible) {
                playersRespawning.add(player);
                PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), TablistManager.class, player);
                Scheduling.syncDelay(Config.TABLIST_RESPAWN_REMOVE_TAB_DELAY.getCurrentValue(), () -> {
                    playersRespawning.remove(player);
                    PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), TablistManager.class, player);
                });
            }
        });
    }
}

