/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util.Static;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class OptionalUtil {
    public static <T> void consume(Optional<T> optional, Runnable runnable, Consumer<T> tConsumer) {
        if (optional.isPresent()) {
            tConsumer.accept(optional.get());
        } else {
            runnable.run();
        }
    }

    public static <T, R> R map(Optional<T> optional, Supplier<R> supplier, Function<T, R> function) {
        if (optional.isPresent()) {
            return function.apply(optional.get());
        }
        return supplier.get();
    }

    public static <S, T extends S> Optional<T> cast(S obj, Class<T> tClass) {
        if (tClass.isInstance(obj)) {
            return Optional.of(obj);
        }
        return Optional.empty();
    }

    public static <T> boolean equal(@Nullable T t, Optional<T> optional) {
        if (optional == null) {
            throw new IllegalArgumentException("The optional argument should not be null");
        }
        if (t == null) {
            return !optional.isPresent();
        }
        return optional.map(t::equals).orElse(false);
    }

    public static <T> boolean referencesEqual(@Nullable T t, Optional<T> optional) {
        if (optional == null) {
            throw new IllegalArgumentException("The optional argument should not be null");
        }
        if (t == null) {
            return !optional.isPresent();
        }
        return optional.map(val -> t == val).orElse(false);
    }
}

