/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import com.pie.tlatoani.Util.Invalidatable;
import com.pie.tlatoani.Util.Static.OptionalUtil;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import mundosk_libraries.packetwrapper.WrapperPlayServerPlayerListHeaderFooter;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardDisplayObjective;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardObjective;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Tablist {
    private final Optional<Player> target;
    private boolean scoresEnabled;
    private final Invalidatable.Creator scoreCreator = new Invalidatable.Creator();
    private String[] header = new String[0];
    private String[] footer = new String[0];
    private Optional<Skin> defaultIcon = Optional.empty();
    private final PlayerTablist playerTablist = new PlayerTablist(this);
    private SupplementaryTablist supplementaryTablist = new SimpleTablist(this.playerTablist);
    public static final Skin DEFAULT_SKIN_TEXTURE = Skin.ALL_WHITE;
    public static final String OBJECTIVE_NAME = "MundoSK_Tablist";

    public Tablist() {
        this.target = Optional.empty();
    }

    Tablist(Player target) {
        this.target = Optional.of(target);
    }

    public Optional<PlayerTablist> getPlayerTablist() {
        if (this.supplementaryTablist.allowExternalPlayerTabModification()) {
            return Optional.of(this.playerTablist);
        }
        return Optional.empty();
    }

    void onJoin(Player player) {
        this.playerTablist.onJoin(player);
    }

    void onQuit(Player player) {
        this.playerTablist.onQuit(player);
    }

    PlayerInfoData onPlayerInfoPacket(PlayerInfoData oldPlayerInfoData, Player objPlayer) {
        if (!this.target.isPresent()) {
            throw new UnsupportedOperationException("This Tablist does not have a target!");
        }
        Player target = this.target.get();
        return this.playerTablist.getTab(objPlayer).map(tab -> {
            WrappedChatComponent displayName = tab.getDisplayName().map(rawDisplayName -> WrappedChatComponent.fromText((String)Optional.ofNullable(target.getScoreboard()).map(scoreboard -> scoreboard.getEntryTeam(objPlayer.getName())).map(team -> team.getPrefix() + rawDisplayName + team.getSuffix()).orElse((String)rawDisplayName))).orElse(oldPlayerInfoData.getDisplayName());
            return new PlayerInfoData(oldPlayerInfoData.getProfile(), tab.getLatency().map(PacketUtil::getPossibleLatency).orElse(oldPlayerInfoData.getLatency()).intValue(), oldPlayerInfoData.getGameMode(), displayName);
        }).orElse(oldPlayerInfoData);
    }

    public boolean arePlayersVisible() {
        return this.playerTablist.arePlayersVisible();
    }

    public boolean isPlayerVisible(Player player) {
        return this.playerTablist.isPlayerVisible(player);
    }

    public SupplementaryTablist getSupplementaryTablist() {
        return this.supplementaryTablist;
    }

    public void setSupplementaryTablist(Function<PlayerTablist, ? extends SupplementaryTablist> supplementaryTablistProvider) {
        this.supplementaryTablist.disable();
        this.supplementaryTablist = null;
        this.supplementaryTablist = supplementaryTablistProvider.apply(this.playerTablist);
    }

    public Optional<Skin> getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(@Nullable Skin icon) {
        if (!OptionalUtil.referencesEqual(icon, this.defaultIcon)) {
            this.defaultIcon = Optional.ofNullable(icon);
            if (this.supplementaryTablist != null) {
                this.supplementaryTablist.refreshIconsIfDefault();
            }
        }
    }

    public boolean areScoresEnabled() {
        return this.scoresEnabled;
    }

    public void setScoresEnabled(boolean enabled) {
        if (enabled) {
            this.enableScores();
        } else {
            this.disableScores();
        }
    }

    public void enableScores() {
        if (!this.areScoresEnabled()) {
            this.scoresEnabled = true;
            WrapperPlayServerScoreboardObjective createPacket = new WrapperPlayServerScoreboardObjective();
            createPacket.setName(OBJECTIVE_NAME);
            createPacket.setDisplayName(OBJECTIVE_NAME);
            createPacket.setMode(0);
            createPacket.setHealthDisplay(WrapperPlayServerScoreboardObjective.HealthDisplay.INTEGER);
            this.sendPacket(createPacket.getHandle(), this);
            WrapperPlayServerScoreboardDisplayObjective displayPacket = new WrapperPlayServerScoreboardDisplayObjective();
            displayPacket.setPosition(0);
            displayPacket.setScoreName(OBJECTIVE_NAME);
            this.sendPacket(displayPacket.getHandle(), this);
        }
    }

    public void disableScores() {
        if (this.areScoresEnabled()) {
            this.scoresEnabled = false;
            WrapperPlayServerScoreboardObjective removePacket = new WrapperPlayServerScoreboardObjective();
            removePacket.setName(OBJECTIVE_NAME);
            removePacket.setDisplayName(OBJECTIVE_NAME);
            removePacket.setMode(1);
            removePacket.setHealthDisplay(WrapperPlayServerScoreboardObjective.HealthDisplay.INTEGER);
            this.sendPacket(removePacket.getHandle(), this);
        }
    }

    Invalidatable<Integer> createScore(int score) {
        if (this.scoresEnabled) {
            return this.scoreCreator.create(score);
        }
        return Invalidatable.invalid();
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[] getFooter() {
        return this.footer;
    }

    public void setHeader(String[] header) {
        this.header = header;
        this.refreshHeaderAndFooter();
    }

    public void setFooter(String[] footer) {
        this.footer = footer;
        this.refreshHeaderAndFooter();
    }

    private void refreshHeaderAndFooter() {
        WrapperPlayServerPlayerListHeaderFooter packet = new WrapperPlayServerPlayerListHeaderFooter();
        packet.setHeader(PacketUtil.stringsToChatComponent(this.header));
        packet.setFooter(PacketUtil.stringsToChatComponent(this.footer));
        this.sendPacket(packet.getHandle(), this);
    }

    public void sendPacket(PacketContainer packet, Object exceptLoc) {
        this.target.filter(OfflinePlayer::isOnline).ifPresent(player -> PacketManager.sendPacket(packet, exceptLoc, player));
    }

    public void applyChanges(Tablist tablist) {
        if (this.areScoresEnabled()) {
            tablist.enableScores();
        }
        if (!(this.getSupplementaryTablist() instanceof SimpleTablist) || !((SimpleTablist)this.getSupplementaryTablist()).isEmpty()) {
            if (tablist.getSupplementaryTablist().getClass() == this.supplementaryTablist.getClass()) {
                this.playerTablist.applyChanges(tablist.playerTablist);
                this.defaultIcon.ifPresent(tablist::setDefaultIcon);
                this.supplementaryTablist.applyChanges(tablist.getSupplementaryTablist());
            } else {
                tablist.setSupplementaryTablist(otherPlayerTablist -> {
                    this.playerTablist.applyChanges((PlayerTablist)otherPlayerTablist);
                    this.defaultIcon.ifPresent(tablist::setDefaultIcon);
                    return this.supplementaryTablist.basicClone((PlayerTablist)otherPlayerTablist);
                });
                this.supplementaryTablist.applyChanges(tablist.getSupplementaryTablist());
            }
        }
        String[] oldHeader = tablist.getHeader();
        String[] newHeader = new String[Math.max(this.header.length, oldHeader.length)];
        for (int i = 0; i < newHeader.length; ++i) {
            newHeader[i] = i < this.header.length && !this.header[i].isEmpty() ? this.header[i] : (i < oldHeader.length ? oldHeader[i] : "");
        }
        String[] oldFooter = tablist.getFooter();
        String[] newFooter = new String[Math.max(this.footer.length, oldFooter.length)];
        for (int i = 0; i < newFooter.length; ++i) {
            newFooter[i] = i < this.footer.length && !this.footer[i].isEmpty() ? this.footer[i] : (i < oldFooter.length ? oldFooter[i] : "");
        }
        tablist.header = newHeader;
        tablist.footer = newFooter;
        tablist.refreshHeaderAndFooter();
    }

    public String toString() {
        return OptionalUtil.map(this.target, () -> super.toString(), player -> "Tablist(" + player.getName() + ")");
    }
}

