/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Generator;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import com.pie.tlatoani.Generator.GeneratorEvent;
import com.pie.tlatoani.Util.Skript.ScopeUtil;
import java.util.Optional;

public class GeneratorFunctionality {
    public final String id;
    private boolean loaded = false;
    public Optional<TriggerItem> initiation = Optional.empty();
    public Optional<TriggerItem> generation = Optional.empty();
    public Optional<TriggerItem> population = Optional.empty();

    public GeneratorFunctionality() {
        this(null);
    }

    public GeneratorFunctionality(String id) {
        this.id = id;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load(Nebula nebula) {
        this.loaded = true;
        this.initiation = nebula.initiation.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"GeneratorInitiation", (Class[])new Class[]{GeneratorEvent.Initiation.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.generation = nebula.generation.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"GeneratorGeneration", (Class[])new Class[]{GeneratorEvent.Generation.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.population = nebula.population.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"GeneratorPopulation", (Class[])new Class[]{GeneratorEvent.Population.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
    }

    public void unload() {
        this.loaded = false;
        this.initiation = Optional.empty();
        this.generation = Optional.empty();
        this.population = Optional.empty();
    }

    public String toString() {
        return "GeneratorFunctionality(TriggerItems: " + this.initiation + "," + this.generation + "," + this.population + ")";
    }

    public static class Nebula {
        public Optional<SectionNode> initiation = Optional.empty();
        public Optional<SectionNode> generation = Optional.empty();
        public Optional<SectionNode> population = Optional.empty();
    }
}

