/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Array;

import com.comphenix.protocol.wrappers.EnumWrappers;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.MathUtil;
import java.util.UUID;

public class ArrayTablist
implements SupplementaryTablist {
    public final Tablist tablist;
    private final PlayerTablist playerTablist;
    public static final String UUID_BEGINNING = "10001000-1000-3000-8000-10001000";
    private int columns;
    private int rows;
    public Skin initialIcon;
    private final Tab[][] tabs = new Tab[4][20];

    public ArrayTablist(PlayerTablist playerTablist, int columns, int rows, Skin initialIcon) {
        this.tablist = playerTablist.tablist;
        this.playerTablist = playerTablist;
        this.columns = MathUtil.limitToRange(1, columns, 4);
        this.rows = ArrayTablist.getViableRowAmount(this.columns, rows);
        this.initialIcon = initialIcon;
        this.addTabs(1, this.columns, 1, this.rows);
        this.changeToIdealPlayerVisibility();
    }

    public static int getViableRowAmount(int columns, int rows) {
        return columns == 1 ? MathUtil.limitToRange(1, rows, 20) : (columns == 2 ? MathUtil.limitToRange(11, rows, 20) : (columns == 3 ? MathUtil.limitToRange(14, rows, 20) : (columns == 4 ? MathUtil.limitToRange(16, rows, 20) : 0)));
    }

    public Tab getTab(int column, int row) {
        if (!MathUtil.isInRange(1.0, column, this.columns)) {
            throw new IllegalArgumentException("Column = " + column + " out of range 1 to " + this.columns);
        }
        if (!MathUtil.isInRange(1.0, row, this.rows)) {
            throw new IllegalArgumentException("Row = " + row + " out of range 1 to " + this.rows);
        }
        return this.tabs[column - 1][row - 1];
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        Logging.debug((Object)this, "Got here, this.columns " + this.columns + ", this.rows " + this.rows + ", columns " + columns);
        columns = MathUtil.limitToRange(1, columns, 4);
        if (columns == this.columns) {
            return;
        }
        if (columns > this.columns) {
            this.setRows(ArrayTablist.getViableRowAmount(columns, this.rows));
            this.addTabs(this.columns + 1, columns, 1, this.rows);
        } else {
            this.removeTabs(columns + 1, this.columns, 1, this.rows);
        }
        this.columns = columns;
        this.changeToIdealPlayerVisibility();
    }

    public void setRows(int rows) {
        Logging.debug((Object)this, "Got here, this.columns " + this.columns + ", this.rows " + this.rows + ", rows " + rows);
        rows = ArrayTablist.getViableRowAmount(this.columns, rows);
        if (rows == this.rows) {
            return;
        }
        if (rows > this.rows) {
            this.addTabs(1, this.columns, this.rows + 1, rows);
        } else {
            this.removeTabs(1, this.columns, rows + 1, this.rows);
        }
        this.rows = rows;
        this.changeToIdealPlayerVisibility();
    }

    private Tab createTab(int column, int row) {
        int identifier = (column - 1) * 20 + row;
        String name = "MundoSK::" + (identifier < 10 ? "0" : "") + identifier;
        UUID uuid = UUID.fromString("10001000-1000-3000-8000-1000100010" + MathUtil.toHexDigit(identifier / 10) + identifier % 10);
        return new Tab(this.tablist.target, name, uuid, "", 5, this.initialIcon, 0);
    }

    private void setTab(int column, int row, Tab tab) {
        this.tabs[column - 1][row - 1] = tab;
    }

    private void addTabs(int columnMin, int columnMax, int rowMin, int rowMax) {
        Logging.debug((Object)this, "Adding Tabs, columnMin = " + columnMin + ", columnMax = " + columnMax + ", rowMin = " + rowMin + ", rowMax = " + rowMax);
        for (int column = columnMin; column <= columnMax; ++column) {
            for (int row = rowMin; row <= rowMax; ++row) {
                Logging.debug((Object)this, "Adding Tab, column = " + column + ", row = " + row);
                Tab tab = this.createTab(column, row);
                tab.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.ADD_PLAYER));
                this.setTab(column, row, tab);
            }
        }
    }

    private void removeTabs(int columnMin, int columnMax, int rowMin, int rowMax) {
        Logging.debug((Object)this, "Removing Tabs, columnMin = " + columnMin + ", columnMax = " + columnMax + ", rowMin = " + rowMin + ", rowMax = " + rowMax);
        for (int column = columnMin; column <= columnMax; ++column) {
            for (int row = rowMin; row <= rowMax; ++row) {
                Logging.debug((Object)this, "Removing Tab, column = " + column + ", row = " + row);
                Tab tab = this.getTab(column, row);
                tab.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.REMOVE_PLAYER));
                tab.setScore(null);
                this.setTab(column, row, null);
            }
        }
    }

    private void changeToIdealPlayerVisibility() {
        if (this.columns == 4 && this.rows == 20) {
            Logging.debug((Object)this, "Columns = " + this.columns + ", Rows = " + this.rows + ", Showing all players");
            this.playerTablist.showAllPlayers();
        } else {
            Logging.debug((Object)this, "Columns = " + this.columns + ", Rows = " + this.rows + ", Hiding all players");
            this.playerTablist.hideAllPlayers();
        }
    }

    @Override
    public void disable() {
        this.removeTabs(1, this.columns, 1, this.rows);
    }

    @Override
    public boolean allowExternalPlayerTabModification() {
        return false;
    }
}

