/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import java.util.Optional;
import java.util.function.Function;
import mundosk_libraries.packetwrapper.WrapperPlayServerPlayerListHeaderFooter;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardDisplayObjective;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardObjective;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardTeam;
import org.bukkit.entity.Player;

public class Tablist {
    public final Player target;
    private boolean scoresEnabled;
    private String[] header = new String[0];
    private String[] footer = new String[0];
    private final PlayerTablist playerTablist = new PlayerTablist(this);
    private SupplementaryTablist supplementaryTablist = new SimpleTablist(this.playerTablist);
    public static final Skin DEFAULT_SKIN_TEXTURE = Skin.ALL_WHITE;
    public static final String OBJECTIVE_NAME = "MundoSK_Tablist";

    public Tablist(Player target) {
        this.target = target;
    }

    public Optional<PlayerTablist> getPlayerTablist() {
        if (this.supplementaryTablist.allowExternalPlayerTabModification()) {
            return Optional.of(this.playerTablist);
        }
        return Optional.empty();
    }

    void onJoin(Player player) {
        this.playerTablist.onJoin(player);
    }

    void onQuit(Player player) {
        this.playerTablist.onQuit(player);
    }

    PlayerInfoData onPlayerInfoPacket(PlayerInfoData oldPlayerInfoData, Player objPlayer) {
        return this.playerTablist.onPlayerInfoPacket(oldPlayerInfoData, objPlayer);
    }

    void onScoreboardTeamPacket(WrapperPlayServerScoreboardTeam packet) {
        this.playerTablist.onScoreboardTeamPacket(packet);
    }

    public boolean arePlayersVisible() {
        return this.playerTablist.arePlayersVisible();
    }

    public boolean isPlayerVisible(Player player) {
        return this.playerTablist.isPlayerVisible(player);
    }

    public SupplementaryTablist getSupplementaryTablist() {
        return this.supplementaryTablist;
    }

    public void setSupplementaryTablist(Function<PlayerTablist, SupplementaryTablist> supplementaryTablistProvider) {
        this.supplementaryTablist.disable();
        this.supplementaryTablist = supplementaryTablistProvider.apply(this.playerTablist);
    }

    public boolean areScoresEnabled() {
        return this.scoresEnabled;
    }

    public void setScoresEnabled(boolean enabled) {
        if (enabled) {
            this.enableScores();
        } else {
            this.disableScores();
        }
    }

    public void enableScores() {
        if (!this.areScoresEnabled()) {
            this.scoresEnabled = true;
            WrapperPlayServerScoreboardObjective createPacket = new WrapperPlayServerScoreboardObjective();
            createPacket.setName(OBJECTIVE_NAME);
            createPacket.setDisplayName(OBJECTIVE_NAME);
            createPacket.setMode(0);
            createPacket.setHealthDisplay(WrapperPlayServerScoreboardObjective.HealthDisplay.INTEGER);
            PacketManager.sendPacket(createPacket.getHandle(), (Object)this, this.target);
            WrapperPlayServerScoreboardDisplayObjective displayPacket = new WrapperPlayServerScoreboardDisplayObjective();
            displayPacket.setPosition(0);
            displayPacket.setScoreName(OBJECTIVE_NAME);
            PacketManager.sendPacket(displayPacket.getHandle(), (Object)this, this.target);
        }
    }

    public void disableScores() {
        if (this.areScoresEnabled()) {
            this.scoresEnabled = false;
            WrapperPlayServerScoreboardObjective removePacket = new WrapperPlayServerScoreboardObjective();
            removePacket.setName(OBJECTIVE_NAME);
            removePacket.setDisplayName(OBJECTIVE_NAME);
            removePacket.setMode(1);
            removePacket.setHealthDisplay(WrapperPlayServerScoreboardObjective.HealthDisplay.INTEGER);
            PacketManager.sendPacket(removePacket.getHandle(), (Object)this, this.target);
        }
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[] getFooter() {
        return this.footer;
    }

    public void setHeader(String[] header) {
        this.header = header;
        this.refreshHeaderAndFooter();
    }

    public void setFooter(String[] footer) {
        this.footer = footer;
        this.refreshHeaderAndFooter();
    }

    private void refreshHeaderAndFooter() {
        WrapperPlayServerPlayerListHeaderFooter packet = new WrapperPlayServerPlayerListHeaderFooter();
        packet.setHeader(PacketUtil.stringsToChatComponent(this.header));
        packet.setFooter(PacketUtil.stringsToChatComponent(this.footer));
        PacketManager.sendPacket(packet.getHandle(), (Object)this, this.target);
    }
}

