/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Chunk;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.pie.tlatoani.Chunk.ExprChunkBlock;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprChunkBlocks
extends SimpleExpression<Block> {
    private Expression<Number> x1Expression = null;
    private Expression<Number> y1Expression = null;
    private Expression<Number> z1Expression = null;
    private Expression<Number> x2Expression = null;
    private Expression<Number> y2Expression = null;
    private Expression<Number> z2Expression = null;
    private Expression<Chunk> chunkExpression;
    private int matchedPattern;
    private int level1;
    private int level2;
    public static final int ALL_BLOCKS = 0;
    public static final int FROM_TO = 1;
    public static final int SINGLE_LAYER = 2;
    public static final int MULTIPLE_LAYER = 3;
    public static final int ALT_MULTIPLE_LAYER = 4;

    public static Block[] region(Chunk chunk, int x1, int y1, int z1, int x2, int y2, int z2) {
        int xn = 1 + x2 - x1;
        int yn = 1 + y2 - y1;
        int zn = 1 + z2 - z1;
        Block[] blocks = new Block[xn * yn * zn];
        int i = 0;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    blocks[i] = chunk.getBlock(x, y, z);
                    ++i;
                }
            }
        }
        return blocks;
    }

    public static Iterator<Block> regionIterator(final Chunk chunk, final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return new Iterator<Block>(){
            int x;
            int y;
            int z;
            {
                this.x = x1;
                this.y = y1;
                this.z = z1;
            }

            @Override
            public boolean hasNext() {
                return this.x <= x2;
            }

            @Override
            public Block next() {
                if (this.x > x2) {
                    throw new NoSuchElementException();
                }
                Block result = chunk.getBlock(this.x, this.y, this.z);
                if (this.z < z2) {
                    ++this.z;
                } else if (this.y < y2) {
                    this.z = z1;
                    ++this.y;
                } else {
                    this.z = z1;
                    this.y = y1;
                    ++this.x;
                }
                return result;
            }
        };
    }

    protected Block[] get(Event event) {
        int x1 = 0;
        int y1 = 0;
        int z1 = 0;
        int x2 = 15;
        int y2 = 15;
        int z2 = 15;
        switch (this.matchedPattern) {
            case 1: {
                x1 = ((Number)this.x1Expression.getSingle(event)).intValue();
                z1 = ((Number)this.z1Expression.getSingle(event)).intValue();
                x2 = ((Number)this.x2Expression.getSingle(event)).intValue();
                z2 = ((Number)this.z2Expression.getSingle(event)).intValue();
            }
            case 3: {
                y1 = ExprChunkBlock.getLevel(this.level1, this.y1Expression, event);
                y2 = ExprChunkBlock.getLevel(this.level2, this.y2Expression, event);
                break;
            }
            case 2: {
                y2 = y1 = ExprChunkBlock.getLevel(this.level1, this.y1Expression, event);
            }
        }
        return ExprChunkBlocks.region((Chunk)this.chunkExpression.getSingle(event), Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public Iterator<Block> iterator(Event event) {
        int x1 = 0;
        int y1 = 0;
        int z1 = 0;
        int x2 = 15;
        int y2 = 15;
        int z2 = 15;
        switch (this.matchedPattern) {
            case 1: {
                x1 = ((Number)this.x1Expression.getSingle(event)).intValue();
                z1 = ((Number)this.z1Expression.getSingle(event)).intValue();
                x2 = ((Number)this.x2Expression.getSingle(event)).intValue();
                z2 = ((Number)this.z2Expression.getSingle(event)).intValue();
            }
            case 3: {
                y1 = ExprChunkBlock.getLevel(this.level1, this.y1Expression, event);
                y2 = ExprChunkBlock.getLevel(this.level2, this.y2Expression, event);
                break;
            }
            case 2: {
                y2 = y1 = ExprChunkBlock.getLevel(this.level1, this.y1Expression, event);
            }
        }
        return ExprChunkBlocks.regionIterator((Chunk)this.chunkExpression.getSingle(event), Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public String toString(Event event, boolean b) {
        switch (this.matchedPattern) {
            case 0: {
                return "all blocks in " + this.chunkExpression;
            }
            case 1: {
                return "blocks from " + this.x1Expression + ", " + this.y1Expression + ", " + this.z1Expression + " to " + this.x2Expression + ", " + this.y2Expression + ", " + this.z2Expression + " in " + this.chunkExpression;
            }
            case 2: {
                return ExprChunkBlock.levelString(this.level1, this.y1Expression) + " in " + this.chunkExpression;
            }
            case 3: {
                return ExprChunkBlock.levelString(this.level1, this.y1Expression) + " to " + ExprChunkBlock.levelString(this.level2, this.y2Expression) + " in " + this.chunkExpression;
            }
        }
        throw new IllegalStateException("Cannot be reached");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.matchedPattern = i;
        if (this.matchedPattern == 4) {
            this.matchedPattern = 3;
        }
        switch (this.matchedPattern) {
            case 0: {
                this.chunkExpression = expressions[0];
                break;
            }
            case 1: {
                this.x1Expression = expressions[0];
                this.y1Expression = expressions[1];
                this.z1Expression = expressions[2];
                this.x2Expression = expressions[3];
                this.y2Expression = expressions[4];
                this.z2Expression = expressions[5];
                this.chunkExpression = expressions[6];
                break;
            }
            case 2: {
                this.level1 = parseResult.mark;
                this.y1Expression = expressions[0];
                this.chunkExpression = expressions[1];
                break;
            }
            case 3: {
                this.level1 = parseResult.mark % 4;
                this.level2 = parseResult.mark >> 2;
                this.y1Expression = expressions[0];
                this.y2Expression = expressions[1];
                this.chunkExpression = expressions[2];
            }
        }
        return true;
    }
}

