/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pie.tlatoani.Skin.ModifiableProfile;
import com.pie.tlatoani.Skin.ProfileManager;
import com.pie.tlatoani.Skin.Skin;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprDisplayedSkinOfPlayer
extends SimpleExpression<Skin> {
    private Expression<Player> playerExpression;
    private Expression<Player> targetExpression;
    private Expression<Player> excludeExpression;
    private boolean consistent;

    protected Skin[] get(Event event) {
        ModifiableProfile profile = ProfileManager.getProfile((Player)this.playerExpression.getSingle(event));
        if (this.targetExpression == null) {
            return new Skin[]{profile.getGeneralDisplayedSkin()};
        }
        return (Skin[])Arrays.stream(this.targetExpression.getArray(event)).map(target -> profile.getSpecificProfile((Player)target).getDisplayedSkin()).toArray(Skin[]::new);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Skin> getReturnType() {
        return Skin.class;
    }

    public String toString(Event event, boolean b) {
        return this.playerExpression + "'s displayed skin" + (this.targetExpression == null ? (this.excludeExpression == null ? (this.consistent ? " consistently" : "") : " excluding " + this.excludeExpression) : " for " + this.targetExpression);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.playerExpression = expressions[0];
        this.targetExpression = expressions[1];
        this.excludeExpression = expressions[2];
        this.consistent = parseResult.mark == 3;
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Skin skinDelta = null;
        if (mode == Changer.ChangeMode.SET) {
            skinDelta = (Skin)delta[0];
        }
        ModifiableProfile profile = ProfileManager.getProfile((Player)this.playerExpression.getSingle(event));
        if (this.targetExpression != null) {
            for (Player target : (Player[])this.targetExpression.getArray(event)) {
                profile.getSpecificProfile(target).setDisplayedSkin(skinDelta);
            }
        } else {
            if (this.excludeExpression != null) {
                for (Player excludedTarget : (Player[])this.excludeExpression.getArray(event)) {
                    ModifiableProfile.Specific specificProfile = profile.getSpecificProfile(excludedTarget);
                    if (specificProfile.displayedSkin != null) continue;
                    specificProfile.displayedSkin = profile.getGeneralDisplayedSkin();
                }
            }
            if (this.consistent) {
                profile.consistentlySetDisplayedSkin(skinDelta);
            } else {
                profile.setGeneralDisplayedSkin(skinDelta);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Skin.class});
        }
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }
}

