/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental.SyntaxPiece;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.google.common.collect.ImmutableSet;
import com.pie.tlatoani.Util.MundoUtil;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.ExpressionConstraints;
import java.util.stream.Collectors;

public final class ExpressionConstraints {
    public final ImmutableSet<Type> types;
    public final Kleenean isLiteral;
    public final int time;
    public final boolean nullable;
    public final String syntax;

    public ExpressionConstraints(ImmutableSet<Type> types, Kleenean isLiteral, int time, boolean nullable) {
        this.types = types;
        this.isLiteral = isLiteral;
        this.time = time;
        this.nullable = nullable;
        String typeOptions = types.stream().map(type -> type.classInfo.getCodeName()).collect(Collectors.joining("/"));
        String isLiteralPrefix = ExpressionConstraints.getLiteralityPrefix((Kleenean)isLiteral);
        String timeSuffix = ExpressionConstraints.getTimeSuffix(time);
        String nullablePrefix = nullable ? "-" : "";
        this.syntax = isLiteralPrefix + nullablePrefix + typeOptions + timeSuffix;
    }

    public ExpressionConstraints(String string) {
        int time;
        boolean nullable;
        Kleenean isLiteral;
        if (string.charAt(0) == '*') {
            isLiteral = Kleenean.TRUE;
            string = string.substring(1);
        } else if (string.charAt(0) == '~') {
            isLiteral = Kleenean.FALSE;
            string = string.substring(1);
        } else {
            isLiteral = Kleenean.UNKNOWN;
        }
        if (string.charAt(0) == '-') {
            nullable = true;
            string = string.substring(0);
        } else {
            nullable = false;
        }
        if (string.endsWith("@1")) {
            time = 1;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("@-1")) {
            time = -1;
            string = string.substring(0, string.length() - 2);
        } else {
            time = 0;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String typeStr : string.split("/")) {
            boolean isSingle;
            if (typeStr.endsWith("s")) {
                isSingle = false;
                typeStr = typeStr.substring(0, typeStr.length() - 1);
            } else {
                isSingle = true;
            }
            ClassInfo classInfo = Classes.getClassInfo((String)typeStr);
            builder.add((Object)new Type(classInfo, isSingle));
        }
        this.types = builder.build();
        this.isLiteral = isLiteral;
        this.time = time;
        this.nullable = nullable;
        this.syntax = string;
    }

    public Class getSuperClass() {
        Class[] classes = new Class[this.types.size()];
        int i = 0;
        for (Type type : this.types) {
            classes[i] = type.classInfo.getC();
            ++i;
        }
        return MundoUtil.commonSuperClass(classes);
    }

    public static String getLiteralityPrefix(Kleenean isLiteral) {
        switch (1.$SwitchMap$ch$njol$util$Kleenean[isLiteral.ordinal()]) {
            case 1: {
                return "*";
            }
            case 2: {
                return "~";
            }
            case 3: {
                return "";
            }
        }
        throw new IllegalArgumentException("Illegal Kleenean isLiteral value: " + isLiteral);
    }

    public static String getTimeSuffix(int time) {
        switch (time) {
            case 1: {
                return "@1";
            }
            case -1: {
                return "@-1";
            }
            case 0: {
                return "0";
            }
        }
        throw new IllegalArgumentException("Illegal int time value: " + time);
    }

    public static class Type {
        public final ClassInfo classInfo;
        public final String codename;
        public final boolean isSingle;

        public Type(String codename, boolean isSingle) {
            this.codename = codename;
            this.classInfo = Classes.getClassInfo((String)codename);
            this.isSingle = isSingle;
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type type = (Type)object;
                return this.isSingle == type.isSingle && this.classInfo.equals(type.classInfo);
            }
            return false;
        }

        public String toString() {
            return "Type(classInfo = " + this.codename + ", isSingle = " + this.isSingle + ")";
        }
    }
}

