/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Tablist.TablistManager;
import com.pie.tlatoani.Util.MathUtil;
import java.util.Arrays;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprLatencyOfTab
extends SimpleExpression<Number> {
    private Expression<String> id;
    private Expression<Player> playerExpression;

    protected Number[] get(Event event) {
        String id = (String)this.id.getSingle(event);
        return (Number[])Arrays.stream(this.playerExpression.getArray(event)).filter(OfflinePlayer::isOnline).map(player -> {
            Tablist tablist = TablistManager.getTablistOfPlayer(player);
            if (tablist.getSupplementaryTablist() instanceof SimpleTablist) {
                SimpleTablist simpleTablist = (SimpleTablist)tablist.getSupplementaryTablist();
                return simpleTablist.getTab(id).map(Tab::getLatency).orElse(null);
            }
            return null;
        }).toArray(Number[]::new);
    }

    public boolean isSingle() {
        return this.playerExpression.isSingle();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return "latency of simple tab " + this.id + " for " + this.playerExpression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = expressions[0];
        this.playerExpression = expressions[1];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String id = (String)this.id.getSingle(event);
        Integer value = MathUtil.limitToRange(0, ((Number)delta[0]).intValue(), 5);
        for (Player player : (Player[])this.playerExpression.getArray(event)) {
            Tablist tablist;
            if (!player.isOnline() || !((tablist = TablistManager.getTablistOfPlayer(player)).getSupplementaryTablist() instanceof SimpleTablist)) continue;
            SimpleTablist simpleTablist = (SimpleTablist)tablist.getSupplementaryTablist();
            simpleTablist.getTab(id).ifPresent(tab -> tab.setLatency(value));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

