/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Skin.ProfileManager;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.Scheduling;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ModifiableProfile {
    public final Player player;
    private Skin actualSkin;
    private Skin generalDisplayedSkin = null;
    private String generalNametag = null;
    private Map<Player, Specific> specificMap = new HashMap<Player, Specific>();

    public ModifiableProfile(Player player) {
        this.player = player;
        this.generalDisplayedSkin = this.getActualSkin();
        this.generalNametag = player.getName();
    }

    public Skin getActualSkin() {
        if (this.actualSkin == null) {
            this.actualSkin = Skin.fromGameProfile(WrappedGameProfile.fromPlayer((Player)this.player));
            Logging.debug((Object)this, "SKINTEXTURE GIVEN BY PROTOCOLLIB FOR PLAYER " + this.player.getName() + " = " + this.actualSkin);
            if (this.actualSkin.toString().equals("[]")) {
                this.actualSkin = null;
            }
        }
        return this.actualSkin;
    }

    public Skin getGeneralDisplayedSkin() {
        return this.generalDisplayedSkin;
    }

    public String getGeneralNametag() {
        return this.generalNametag;
    }

    public Specific getSpecificProfile(Player target) {
        if (target == null || !target.isOnline()) {
            throw new IllegalArgumentException("Target must be non-null and online: " + target);
        }
        return this.specificMap.computeIfAbsent(target, x$0 -> new Specific((Player)x$0));
    }

    void onQuit(Player left) {
        this.specificMap.remove(left);
    }

    public void setGeneralDisplayedSkin(Skin value) {
        if (value == null) {
            value = this.getActualSkin();
        }
        this.generalDisplayedSkin = value;
        Bukkit.getOnlinePlayers().stream().map(this::getSpecificProfile).filter(specific -> specific.displayedSkin == null).forEach(rec$ -> ((Specific)rec$).changeDisplayedSkin());
    }

    public void setGeneralNametag(String value) {
        if (value == null) {
            value = this.player.getName();
        } else if (value.length() > 16) {
            value = value.substring(0, 16);
        }
        String oldValue = this.generalNametag;
        this.generalNametag = value;
        Bukkit.getOnlinePlayers().stream().map(this::getSpecificProfile).filter(specific -> specific.nametag == null).filter(specific -> !this.player.equals(specific.target)).forEach(specific -> ((Specific)specific).changeNametag(oldValue, this.generalNametag));
    }

    public void consistentlySetDisplayedSkin(Skin value) {
        if (value == null) {
            value = this.getActualSkin();
        }
        this.generalDisplayedSkin = value;
        Bukkit.getOnlinePlayers().stream().map(this::getSpecificProfile).forEach(specific -> {
            specific.displayedSkin = null;
            ((Specific)specific).changeDisplayedSkin();
        });
    }

    public void consistentlySetNametag(String value) {
        if (value == null) {
            value = this.player.getName();
        } else if (value.length() > 16) {
            value = value.substring(0, 16);
        }
        String oldValue = this.generalNametag;
        this.generalNametag = value;
        Bukkit.getOnlinePlayers().stream().map(this::getSpecificProfile).filter(specific -> !this.player.equals(specific.target)).forEach(specific -> {
            String specificOldValue = specific.nametag == null ? oldValue : specific.nametag;
            specific.nametag = null;
            ((Specific)specific).changeNametag(specificOldValue, this.generalNametag);
        });
    }

    public class Specific {
        public final Player target;
        Skin displayedSkin = null;
        String nametag = null;

        private Specific(Player target) {
            this.target = target;
            if (ModifiableProfile.this.player.equals(target)) {
                this.nametag = ModifiableProfile.this.player.getName();
            }
        }

        private void changeDisplayedSkin() {
            ProfileManager.refreshPlayer(ModifiableProfile.this.player, this.target);
        }

        private void changeNametag(String oldValue, String value) {
            if (ModifiableProfile.this.player.equals(this.target)) {
                throw new UnsupportedOperationException("You can't change the nametag of a player for themselves!");
            }
            Logging.debug((Object)this, "Setting nametag of " + ModifiableProfile.this.player.getName() + " to " + value + " for " + this.target.getName());
            Scoreboard scoreboard = this.target.getScoreboard();
            Objective objective = null;
            Score score = null;
            int actualScore = 0;
            if (scoreboard != null) {
                Team team = scoreboard.getEntryTeam(ModifiableProfile.this.player.getName());
                if (team != null) {
                    team.removeEntry(ModifiableProfile.this.player.getName());
                    Scheduling.syncDelay(1, () -> team.addEntry(ModifiableProfile.this.player.getName()));
                }
                if ((objective = scoreboard.getObjective(DisplaySlot.BELOW_NAME)) != null) {
                    score = objective.getScore(ModifiableProfile.this.player.getName());
                    actualScore = score.getScore();
                    score.setScore(0);
                }
            }
            ProfileManager.refreshPlayer(ModifiableProfile.this.player, this.target);
            if (scoreboard != null) {
                if (objective != null) {
                    score.setScore(actualScore);
                }
                for (ModifiableProfile profile : ProfileManager.profileMap.values()) {
                    Team team;
                    Specific specific = profile.getSpecificProfile(this.target);
                    if (!oldValue.equals(specific.getNametag()) || (team = scoreboard.getEntryTeam(profile.player.getName())) == null) continue;
                    team.removeEntry(profile.player.getName());
                    Scheduling.syncDelay(1, () -> team.addEntry(profile.player.getName()));
                }
            }
        }

        public Skin getDisplayedSkin() {
            return this.displayedSkin == null ? ModifiableProfile.this.generalDisplayedSkin : this.displayedSkin;
        }

        public String getNametag() {
            return this.nametag == null ? ModifiableProfile.this.generalNametag : this.nametag;
        }

        public void setDisplayedSkin(Skin value) {
            this.displayedSkin = value;
            this.changeDisplayedSkin();
        }

        public void setNametag(String value) {
            if (ModifiableProfile.this.player.equals(this.target)) {
                return;
            }
            if (value != null && value.length() > 16) {
                value = value.substring(0, 16);
            }
            String oldValue = this.nametag;
            this.nametag = value;
            this.changeNametag(oldValue == null ? ModifiableProfile.this.generalNametag : oldValue, value == null ? ModifiableProfile.this.generalNametag : value);
        }
    }
}

