/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.TablistManager;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.Reflection;
import com.pie.tlatoani.Util.Scheduling;
import com.pie.tlatoani.Util.WorldLockedLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public class SkinManager {
    private static final HashMap<Player, Skin> actualSkins = new HashMap();
    private static final HashMap<Player, Skin> displayedSkins = new HashMap();
    private static final Table<Player, Player, Skin> personalDisplayedSkins = Tables.newCustomTable(new HashMap(), HashMap::new);
    private static final HashMap<Player, String> nameTags = new HashMap();
    private static final ArrayList<Player> spawnedPlayers = new ArrayList();
    private static Reflection.MethodInvoker CRAFT_PLAYER_GET_HANDLE = null;
    private static Reflection.MethodInvoker DEDICATED_PLAYER_LIST_MOVE_TO_WORLD = null;

    public static void loadReflectionStuff() {
        try {
            CRAFT_PLAYER_GET_HANDLE = Reflection.getTypedMethod(Reflection.getCraftBukkitClass("entity.CraftPlayer"), "getHandle", Reflection.getMinecraftClass("EntityPlayer"), new Class[0]);
            DEDICATED_PLAYER_LIST_MOVE_TO_WORLD = Reflection.getMethod(Reflection.getMinecraftClass("DedicatedPlayerList"), "moveToWorld", Reflection.getMinecraftClass("EntityPlayer"), Integer.TYPE, Boolean.TYPE, Location.class, Boolean.TYPE);
        }
        catch (Exception e) {
            Logging.reportException(SkinManager.class, e);
        }
    }

    public static void loadPacketEvents() {
        PacketManager.onPacketEvent(PacketType.Play.Server.PLAYER_INFO, event -> {
            if (event.getPacket().getPlayerInfoAction().read(0) == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
                Logging.debug(SkinManager.class, "EVENT.GETPLAYER = " + event.getPlayer().getName());
                List playerInfoDatas = (List)event.getPacket().getPlayerInfoDataLists().readSafely(0);
                ArrayList<PlayerInfoData> newPlayerInfoDatas = new ArrayList<PlayerInfoData>();
                for (PlayerInfoData playerInfoData : playerInfoDatas) {
                    Player player = Bukkit.getPlayer((UUID)playerInfoData.getProfile().getUUID());
                    PlayerInfoData newPlayerInfoData = playerInfoData;
                    if (player != null && !spawnedPlayers.contains(player)) {
                        Logging.debug(SkinManager.class, "NEW PLAYER !");
                        spawnedPlayers.add(player);
                        if (!actualSkins.containsKey(player) && !actualSkins.containsKey(player)) {
                            Skin skin = Skin.fromGameProfile(playerInfoData.getProfile());
                            Logging.debug(SkinManager.class, "ALTERNATIVE SKINTEXTURE FOUND IN PACKET = " + skin);
                            if (!skin.toString().equals("[]")) {
                                actualSkins.put(player, skin);
                                displayedSkins.put(player, skin);
                            }
                        }
                    }
                    if (player != null) {
                        Logging.debug(SkinManager.class, "Pre Namtatg: " + playerInfoData.getProfile().getName());
                        String nameTag = SkinManager.getNameTag(player);
                        newPlayerInfoData = new PlayerInfoData(playerInfoData.getProfile().withName(nameTag), playerInfoData.getLatency(), playerInfoData.getGameMode(), playerInfoData.getDisplayName());
                        Logging.debug(SkinManager.class, "Post Namtatg: " + newPlayerInfoData.getProfile().getName());
                        Skin skin = SkinManager.getPersonalDisplayedSkin(player, event.getPlayer());
                        Logging.debug(SkinManager.class, "PLAYER ACTUAL NAME: " + player.getName());
                        Logging.debug(SkinManager.class, "SKINTEXTURE REPLACEMENT (MAY OR MAY NOT EXIST): " + skin);
                        if (skin != null) {
                            newPlayerInfoData.getProfile().getProperties().put((Object)Skin.MULTIMAP_KEY, (Object)skin.toWrappedSignedProperty());
                        }
                    }
                    newPlayerInfoDatas.add(newPlayerInfoData);
                }
                event.getPacket().getPlayerInfoDataLists().writeSafely(0, newPlayerInfoDatas);
            }
        });
        PacketManager.onPacketEvent(PacketType.Play.Server.SCOREBOARD_TEAM, event -> {
            if (!event.isCancelled() && event.getPlayer() != null) {
                Collection playerNames = (Collection)event.getPacket().getSpecificModifier(Collection.class).readSafely(0);
                Logging.debug(SkinManager.class, "playerNames: " + playerNames);
                ArrayList<String> addedNames = new ArrayList<String>();
                for (String s : playerNames) {
                    Player player = Bukkit.getPlayerExact((String)s);
                    if (player == null) continue;
                    String nameTag = SkinManager.getNameTag(player);
                    if (!nameTag.equals(s)) {
                        addedNames.add(nameTag);
                    }
                    Logging.debug(SkinManager.class, "Player " + s + ", Nametag " + nameTag);
                }
                Logging.debug(SkinManager.class, "addedNames: " + addedNames);
                HashSet<String> finalNames = new HashSet<String>();
                finalNames.addAll(playerNames);
                finalNames.addAll(addedNames);
                Logging.debug(SkinManager.class, "finalNames: " + finalNames);
                event.getPacket().getSpecificModifier(Collection.class).writeSafely(0, finalNames);
            }
        });
        PacketManager.onPacketEvent(PacketType.Play.Server.SCOREBOARD_SCORE, event -> {
            Player player;
            StructureModifier stringStructureModifier = event.getPacket().getStrings();
            String actualString = (String)stringStructureModifier.read(0);
            Player player2 = player = actualString == null ? null : Bukkit.getPlayerExact((String)actualString);
            if (player != null) {
                stringStructureModifier.writeSafely(0, (Object)SkinManager.getNameTag(player));
                Logging.debug(SkinManager.class, "REPLACING SCORE IN NAME " + actualString);
            }
        });
    }

    private SkinManager() {
    }

    static void onJoin(Player player) {
        nameTags.put(player, player.getName());
        SkinManager.getActualSkin(player);
        SkinManager.getNameTag(player);
    }

    static void onQuit(Player player) {
        actualSkins.remove(player);
        displayedSkins.remove(player);
        for (Player target : Bukkit.getOnlinePlayers()) {
            personalDisplayedSkins.remove((Object)player, (Object)target);
            personalDisplayedSkins.remove((Object)target, (Object)player);
        }
        personalDisplayedSkins.remove((Object)player, (Object)player);
        nameTags.remove(player);
        spawnedPlayers.remove(player);
    }

    public static Skin getActualSkin(Player player) {
        Skin skin = actualSkins.get(player);
        if (skin == null) {
            skin = Skin.fromGameProfile(WrappedGameProfile.fromPlayer((Player)player));
            Logging.debug(SkinManager.class, "SKINTEXTURE GIVEN BY PROTOCOLLIB FOR PLAYER " + player.getName() + " = " + skin);
            if (!skin.toString().equals("[]")) {
                actualSkins.put(player, skin);
                if (!displayedSkins.containsKey(player)) {
                    displayedSkins.put(player, skin);
                }
            }
        }
        Logging.debug(SkinManager.class, "ACTUALSKIN OF PLAYER " + player.getName() + " = " + skin);
        return skin;
    }

    public static Skin getDisplayedSkin(Player player) {
        return displayedSkins.get(player);
    }

    public static void setDisplayedSkin(Player player, Skin skin) {
        Logging.debug(SkinManager.class, "SETTING DISPLAYED SKIN OF" + player.getName() + " TO " + skin);
        if (skin != null && !skin.toString().equals("[]")) {
            displayedSkins.put(player, skin);
        } else {
            displayedSkins.put(player, SkinManager.getActualSkin(player));
        }
        if (spawnedPlayers.contains(player)) {
            ArrayList targets = new ArrayList();
            targets.addAll(Bukkit.getOnlinePlayers());
            targets.removeAll(personalDisplayedSkins.row((Object)player).keySet());
            SkinManager.specificallyRefreshPlayer(player, targets);
            if (!personalDisplayedSkins.contains((Object)player, (Object)player)) {
                SkinManager.respawnPlayer(player);
            }
        }
    }

    public static Skin getPersonalDisplayedSkin(Player player, Player target) {
        Skin result = (Skin)personalDisplayedSkins.get((Object)player, (Object)target);
        if (result == null) {
            result = SkinManager.getDisplayedSkin(player);
        }
        return result;
    }

    public static void setPersonalDisplayedSkin(Player player, Collection<Player> targets, Skin value) {
        for (Player target : targets) {
            if (value != null) {
                personalDisplayedSkins.put((Object)player, (Object)target, (Object)value);
                continue;
            }
            personalDisplayedSkins.remove((Object)player, (Object)target);
        }
        if (spawnedPlayers.contains(player)) {
            SkinManager.specificallyRefreshPlayer(player, targets);
            if (targets.contains(player)) {
                SkinManager.respawnPlayer(player);
            }
        }
    }

    public static void setDisplayedSkinExcluding(Player player, Collection<Player> excludes, Skin value) {
        Skin oldSkin = displayedSkins.get(player);
        for (Player exclude : excludes) {
            if (personalDisplayedSkins.contains((Object)player, (Object)exclude)) continue;
            if (oldSkin != null) {
                personalDisplayedSkins.put((Object)player, (Object)exclude, (Object)oldSkin);
                continue;
            }
            personalDisplayedSkins.remove((Object)player, (Object)exclude);
        }
        SkinManager.setDisplayedSkin(player, value);
    }

    public static String getNameTag(Player player) {
        return nameTags.computeIfAbsent(player, k -> player.getName());
    }

    public static void setNameTag(Player player, String nameTag) {
        Team team;
        if (nameTag != null && nameTag.length() > 16) {
            nameTag = nameTag.substring(0, 16);
        }
        Logging.debug(SkinManager.class, "Setting nametag of " + player.getName() + " to " + nameTag);
        String oldNameTag = SkinManager.getNameTag(player);
        if (nameTag == null) {
            nameTag = player.getName();
        }
        Team team2 = team = player.getScoreboard() != null ? player.getScoreboard().getEntryTeam(player.getName()) : null;
        if (team != null) {
            team.removeEntry(player.getName());
            Scheduling.syncDelay(1, () -> team.addEntry(player.getName()));
        }
        Objective objective = player.getScoreboard() != null ? player.getScoreboard().getObjective(DisplaySlot.BELOW_NAME) : null;
        Score score = null;
        int actualScore = 0;
        if (objective != null) {
            score = objective.getScore(player.getName());
            actualScore = score.getScore();
            score.setScore(0);
        }
        nameTags.put(player, nameTag);
        SkinManager.refreshPlayer(player);
        if (objective != null) {
            score.setScore(actualScore);
        }
        nameTags.forEach((nameTagOwner, s) -> {
            if (s.equals(oldNameTag)) {
                Team team1;
                Team team = team1 = nameTagOwner.getScoreboard() != null ? nameTagOwner.getScoreboard().getEntryTeam(nameTagOwner.getName()) : null;
                if (team1 != null) {
                    team1.removeEntry(nameTagOwner.getName());
                    Scheduling.syncDelay(1, () -> team1.addEntry(nameTagOwner.getName()));
                }
            }
        });
    }

    private static void refreshPlayer(Player player) {
        SkinManager.specificallyRefreshPlayer(player, Bukkit.getOnlinePlayers());
    }

    private static void specificallyRefreshPlayer(Player player, Collection<? extends Player> targets) {
        Logging.debug(SkinManager.class, "Now hiding player " + player.getName());
        for (Player player2 : targets) {
            if (player2.equals(player)) continue;
            player2.hidePlayer(player);
        }
        Scheduling.syncDelay(1, () -> {
            Logging.debug(SkinManager.class, "Now showing player " + player.getName());
            for (Player target : targets) {
                if (target.equals(player)) continue;
                target.showPlayer(player);
            }
        });
        Scheduling.syncDelay(2, () -> {
            PacketContainer hidePacket = PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            for (Player target : targets) {
                if (TablistManager.getTablistOfPlayer(target).isPlayerVisible(player)) continue;
                PacketManager.sendPacket(hidePacket, SkinManager.class, target);
            }
        });
    }

    private static void respawnPlayer(Player player) {
        PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), SkinManager.class, player);
        PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), SkinManager.class, player);
        WorldLockedLocation playerLoc = new WorldLockedLocation(player.getLocation());
        Logging.debug(SkinManager.class, "playerLoc1 = " + (Object)((Object)playerLoc));
        try {
            Logging.debug(SkinManager.class, "DEDICATED_PLAYER_LIST_MOVE_TO_WORLD: " + DEDICATED_PLAYER_LIST_MOVE_TO_WORLD);
            Logging.debug(SkinManager.class, "NMS_SERVER: " + DEDICATED_PLAYER_LIST_MOVE_TO_WORLD);
            Logging.debug(SkinManager.class, "DEDICATED_PLAYER_LIST_MOVE_TO_WORLD: " + DEDICATED_PLAYER_LIST_MOVE_TO_WORLD);
            DEDICATED_PLAYER_LIST_MOVE_TO_WORLD.invoke(Reflection.NMS_SERVER, new Object[]{CRAFT_PLAYER_GET_HANDLE.invoke(player, new Object[0]), SkinManager.convertDimension(player.getWorld().getEnvironment()), true, playerLoc, true});
        }
        catch (Exception e) {
            Logging.debug(SkinManager.class, "Failed to make player see his skin change: " + player.getName());
            Logging.reportException(SkinManager.class, e);
        }
    }

    private static int convertDimension(World.Environment dimension) {
        switch (dimension) {
            case NETHER: {
                return -1;
            }
            case THE_END: {
                return 1;
            }
        }
        return 0;
    }
}

