/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldBorder.BorderEvent;

import com.pie.tlatoani.WorldBorder.BorderEvent.BorderStabilizeEvent;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;

public class WorldBorderImpl
implements WorldBorder {
    public final World world;
    protected final WorldBorder border;
    private Optional<BorderStabilizeEvent.Caller> caller = Optional.empty();
    private Optional<Double> originalDiameter = Optional.empty();
    private Optional<Double> eventualDiameter = Optional.empty();
    private Optional<Double> totalTimeInSeconds = Optional.empty();

    public WorldBorderImpl(World world) {
        this.world = world;
        this.border = world.getWorldBorder();
    }

    void onStabilize() {
        this.caller = Optional.empty();
        this.originalDiameter = Optional.empty();
        this.eventualDiameter = Optional.empty();
        this.totalTimeInSeconds = Optional.empty();
    }

    private void onSetSizeOverTime(double newDiameter, long seconds) {
        this.caller.ifPresent(BorderStabilizeEvent.Caller::invalidate);
        BorderStabilizeEvent.Caller caller = new BorderStabilizeEvent.Caller(this.world, this);
        caller.schedule((int)seconds * 20);
        this.caller = Optional.of(caller);
        this.originalDiameter = Optional.of(this.getSize());
        this.eventualDiameter = Optional.of(newDiameter);
        this.totalTimeInSeconds = Optional.of(Double.valueOf(seconds));
    }

    public double getOriginalDiameter() {
        return this.originalDiameter.orElse(this.getSize());
    }

    public double getEventualDiameter() {
        return this.eventualDiameter.orElse(this.getSize());
    }

    public boolean isMoving() {
        return this.caller.isPresent();
    }

    public double getRemainingDistance() {
        if (!this.isMoving()) {
            return 0.0;
        }
        return Math.abs(this.getEventualDiameter() - this.getSize());
    }

    public double remainingTimeInSeconds() {
        if (!this.isMoving()) {
            return 0.0;
        }
        return this.totalTimeInSeconds.get() * (this.getRemainingDistance() / Math.abs(this.getEventualDiameter() - this.getOriginalDiameter()));
    }

    public void reset() {
        this.border.reset();
    }

    public double getSize() {
        return this.border.getSize();
    }

    public void setSize(double v) {
        this.border.setSize(v);
    }

    public void setSize(double v, long l) {
        this.onSetSizeOverTime(v, l);
        this.border.setSize(v, l);
    }

    public Location getCenter() {
        return this.border.getCenter();
    }

    public void setCenter(double v, double v1) {
        this.border.setCenter(v, v1);
    }

    public void setCenter(Location location) {
        this.border.setCenter(location);
    }

    public double getDamageBuffer() {
        return this.border.getDamageBuffer();
    }

    public void setDamageBuffer(double v) {
        this.border.setDamageBuffer(v);
    }

    public double getDamageAmount() {
        return this.border.getDamageAmount();
    }

    public void setDamageAmount(double v) {
        this.border.setDamageAmount(v);
    }

    public int getWarningTime() {
        return this.border.getWarningTime();
    }

    public void setWarningTime(int i) {
        this.border.setWarningTime(i);
    }

    public int getWarningDistance() {
        return this.border.getWarningDistance();
    }

    public void setWarningDistance(int i) {
        this.border.setWarningDistance(i);
    }

    public boolean isInside(Location location) {
        throw new UnsupportedOperationException("This version of Bukkit/Spigot does not support the isInside(Location) method");
    }
}

