/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Player;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.ProtocolLib.PacketUtil;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tab;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.Config;
import com.pie.tlatoani.Util.MundoUtil;
import com.pie.tlatoani.Util.Scheduling;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mundosk_libraries.packetwrapper.WrapperPlayServerScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerTablist {
    public final Tablist tablist;
    private Optional<Map<Player, Optional<Tab>>> tabs = Optional.of(new HashMap());

    public PlayerTablist(Tablist tablist) {
        this.tablist = tablist;
    }

    public Optional<Tab> getTab(Player player) {
        return this.tabs.flatMap(map -> Optional.ofNullable(map.get(player)).orElse(Optional.empty()));
    }

    public Optional<Tab> forceTab(Player player) {
        return this.tabs.flatMap(map -> map.computeIfAbsent(player, __ -> Optional.of(new PlayerTab(this.tablist.target, player))));
    }

    public boolean isPlayerVisible(Player player) {
        return this.tabs.map(map -> Optional.ofNullable(map.get(player)).map(Optional::isPresent).orElse(true)).orElse(false);
    }

    public void showPlayer(Player player) {
        if (!this.tabs.isPresent()) {
            this.tabs = Optional.of(new HashMap());
            this.tabs.ifPresent(map -> {
                for (Player player1 : Bukkit.getOnlinePlayers()) {
                    map.put(player1, Optional.empty());
                }
            });
        }
        this.tabs.ifPresent(map -> map.computeIfPresent(player, (__, tabOptional) -> {
            if (!tabOptional.isPresent()) {
                PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), PlayerTablist.class, this.tablist.target);
                return null;
            }
            return tabOptional;
        }));
    }

    public void hidePlayer(Player player) {
        this.tabs.ifPresent(map -> map.compute(player, (__, tabOptional) -> {
            if (tabOptional == null || tabOptional.isPresent()) {
                PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), (Object)this, this.tablist.target);
            }
            return Optional.empty();
        }));
    }

    public boolean arePlayersVisible() {
        return this.tabs.isPresent();
    }

    public void showAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.showPlayer(player);
        }
    }

    public void hideAllPlayers() {
        this.tabs.ifPresent(map -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Optional playerTabOptional = (Optional)map.get(player);
                if (playerTabOptional != null && !playerTabOptional.isPresent()) continue;
                PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), (Object)this, this.tablist.target);
            }
            this.tabs = Optional.empty();
        });
    }

    public void clearModifications() {
        MundoUtil.consumeOptional(this.tabs, map -> {
            map.forEach((player, tabOptional) -> MundoUtil.consumeOptional(tabOptional, tab -> {
                if (tab.getDisplayName() != null) {
                    tab.setDisplayName(null);
                }
                if (tab.getLatency() != null) {
                    tab.setLatency(null);
                }
                if (tab.getScore() != null) {
                    tab.setScore(null);
                }
            }, () -> PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), (Object)this, this.tablist.target)));
            map.clear();
        }, this::showAllPlayers);
    }

    public void onJoin(Player player) {
        if (!this.tabs.isPresent()) {
            Scheduling.syncDelay(Config.TABLIST_SPAWN_REMOVE_TAB_DELAY.getCurrentValue(), () -> PacketManager.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), (Object)this, this.tablist.target));
        }
    }

    public void onQuit(Player player) {
        this.tabs.ifPresent(map -> {
            Optional cfr_ignored_0 = (Optional)map.remove(player);
        });
    }

    public PlayerInfoData onPlayerInfoPacket(PlayerInfoData oldPlayerInfoData, Player objPlayer) {
        return this.getTab(objPlayer).map(tab -> {
            WrappedChatComponent displayName = Optional.ofNullable(tab.getDisplayName()).map(rawDisplayName -> WrappedChatComponent.fromText((String)Optional.ofNullable(this.tablist.target.getScoreboard()).map(scoreboard -> scoreboard.getEntryTeam(objPlayer.getName())).map(team -> team.getPrefix() + rawDisplayName + team.getSuffix()).orElse((String)rawDisplayName))).orElse(oldPlayerInfoData.getDisplayName());
            return new PlayerInfoData(oldPlayerInfoData.getProfile(), Optional.ofNullable(tab.getLatency()).orElse(oldPlayerInfoData.getLatency()).intValue(), oldPlayerInfoData.getGameMode(), displayName);
        }).orElse(oldPlayerInfoData);
    }

    public void onScoreboardTeamPacket(WrapperPlayServerScoreboardTeam packet) {
        for (String playerName : packet.getPlayers()) {
            Player objPlayer = Bukkit.getPlayerExact((String)playerName);
            if (objPlayer == null) continue;
            this.getTab(objPlayer).filter(tab -> tab.getDisplayName() != null).ifPresent(tab -> tab.sendPacket(tab.playerInfoPacket(EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME)));
        }
    }

    public static class PlayerTab
    extends Tab {
        private final Player objPlayer;

        public PlayerTab(Player target, Player player) {
            super(target, player.getName(), player.getUniqueId(), null, null, null, 0);
            this.objPlayer = player;
        }

        @Override
        public PacketContainer playerInfoPacket(EnumWrappers.PlayerInfoAction action) {
            return PacketUtil.playerInfoPacket(this.objPlayer, action);
        }

        @Override
        public void setIcon(Skin value) {
            throw new UnsupportedOperationException("You can't set the icon of a PlayerTab!");
        }
    }
}

