/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import com.google.common.collect.ImmutableList;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Registration.Documentation;
import com.pie.tlatoani.Registration.DocumentationElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DocumentationFileGenerator {
    public static String FILENAME = "docs.json";

    public static void generateDocumentationFile() throws IOException {
        File file = DocumentationFileGenerator.getDocumentationFile();
        JSONObject docsJSON = new JSONObject();
        docsJSON.put((Object)"events", (Object)DocumentationFileGenerator.jsonArrayOfDocElems(Documentation.getEvents()));
        docsJSON.put((Object)"conditions", (Object)DocumentationFileGenerator.jsonArrayOfDocElems(Documentation.getConditions()));
        docsJSON.put((Object)"effects", (Object)DocumentationFileGenerator.jsonArrayOfDocElems(Documentation.getEffects(), Documentation.getScopes()));
        docsJSON.put((Object)"expressions", (Object)DocumentationFileGenerator.jsonArrayOfDocElems(Documentation.getExpressions()));
        docsJSON.put((Object)"types", (Object)DocumentationFileGenerator.jsonArrayOfDocElems(Documentation.getTypes()));
        FileWriter fileWriter = new FileWriter(file);
        docsJSON.writeJSONString((Writer)fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    public static File getDocumentationFile() throws IOException {
        File result = new File(Mundo.INSTANCE.getDataFolder().getAbsolutePath() + File.separator + FILENAME);
        if (!result.exists()) {
            result.createNewFile();
        }
        return result;
    }

    public static JSONArray jsonArrayOfDocElems(List<? extends DocumentationElement> ... docElemLists) {
        JSONArray result = new JSONArray();
        for (List<? extends DocumentationElement> docElems : docElemLists) {
            for (DocumentationElement documentationElement : docElems) {
                result.add((Object)DocumentationFileGenerator.jsonOfDocElem(documentationElement));
            }
        }
        return result;
    }

    public static JSONObject jsonOfDocElem(DocumentationElement docElem) {
        String mode;
        JSONArray changers;
        JSONObject result = new JSONObject();
        result.put((Object)"name", (Object)docElem.name);
        result.put((Object)"id", (Object)DocumentationFileGenerator.idFromName(docElem.name));
        result.put((Object)"since", (Object)DocumentationFileGenerator.fromStringArray(docElem.originVersion));
        if (docElem instanceof DocumentationElement.Expression) {
            result.put((Object)"return type", (Object)((DocumentationElement.Expression)docElem).type.getDocName());
        }
        JSONArray descJSON = DocumentationFileGenerator.fromStringList(docElem.description);
        if (docElem instanceof DocumentationElement.Scope) {
            descJSON.add(0, (Object)"Not an effect, but rather a scope (written with a colon at the end with a section of indented code under it, like an if statement or loop). ");
        }
        result.put((Object)"description", (Object)descJSON);
        result.put((Object)"patterns", (Object)DocumentationFileGenerator.fromStringList(docElem.syntaxes));
        if (docElem instanceof DocumentationElement.Type) {
            DocumentationElement.Type typeDocElem = (DocumentationElement.Type)docElem;
            if (typeDocElem.usages.size() > 0) {
                result.put((Object)"usage", (Object)DocumentationFileGenerator.fromStringList(typeDocElem.usages));
            }
        }
        if (docElem instanceof DocumentationElement.Expression) {
            DocumentationElement.Expression exprDocElem = (DocumentationElement.Expression)docElem;
            if (exprDocElem.changers.size() > 0) {
                changers = new JSONArray();
                for (DocumentationElement.Changer changer : exprDocElem.changers) {
                    mode = changer.mode.name().toLowerCase().replace('_', ' ');
                    if (changers.contains((Object)mode)) continue;
                    changers.add((Object)mode);
                }
                result.put((Object)"changers", (Object)changers);
            }
        } else if (docElem instanceof DocumentationElement.Condition) {
            DocumentationElement.Condition condDocElem = (DocumentationElement.Condition)docElem;
            if (condDocElem.changers.size() > 0) {
                changers = new JSONArray();
                for (DocumentationElement.Changer changer : condDocElem.changers) {
                    mode = changer.mode.name().toLowerCase().replace('_', ' ');
                    if (changers.contains((Object)mode)) continue;
                    changers.add((Object)mode);
                }
                result.put((Object)"changers", (Object)changers);
            }
        }
        if (docElem instanceof DocumentationElement.Event) {
            DocumentationElement.Event eventDocElem = (DocumentationElement.Event)docElem;
            if (eventDocElem.eventValues.size() > 0) {
                JSONArray eventValues = new JSONArray();
                for (DocumentationElement.EventValue eventValue : eventDocElem.eventValues) {
                    eventValues.add((Object)("event-" + eventValue.type.getCodeName()));
                }
                result.put((Object)"event values", (Object)eventValues);
            }
            result.put((Object)"cancellable", (Object)eventDocElem.cancellable);
        }
        if (docElem.examples.size() == 1) {
            result.put((Object)"examples", (Object)DocumentationFileGenerator.fromStringList((List)docElem.examples.get(0)));
        } else if (docElem.examples.size() > 1) {
            JSONArray examples = new JSONArray();
            for (int i = 1; i <= docElem.examples.size(); ++i) {
                if (!examples.isEmpty()) {
                    examples.add((Object)"");
                }
                examples.add((Object)("#Example " + i));
                for (String line : (ImmutableList)docElem.examples.get(i - 1)) {
                    examples.add((Object)line);
                }
            }
            result.put((Object)"examples", (Object)examples);
        }
        return result;
    }

    public static String idFromName(String name) {
        return name.toLowerCase().replace(' ', '_');
    }

    public static JSONArray fromStringArray(String ... array) {
        JSONArray jsonArray = new JSONArray();
        for (String elem : array) {
            jsonArray.add((Object)elem);
        }
        return jsonArray;
    }

    public static JSONArray fromStringList(List<String> list) {
        JSONArray jsonArray = new JSONArray();
        for (String elem : list) {
            jsonArray.add((Object)elem);
        }
        return jsonArray;
    }
}

